/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.List;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.VALUE)
public class ValueOperation
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(ValueOperation.class);

    public ValueOperation() {
        super(OperationType.VALUE);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        if (!this.rightOperand.isEmpty()) {
            OperationExpression operation;
            Object result;
            Expression right = (Expression)this.rightOperand.get(0);
            if (right instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)right;
                Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
                if (instance instanceof List) {
                    List dataSet = (List)instance;
                    Object value = this.getValue(dataSet.get(0), variableExpression.getName());
                    return LiteralType.getLiteralExpression(value, variableExpression.getType());
                }
                Object value = this.getValue(instance, variableExpression.getName());
                return LiteralType.getLiteralExpression(value, variableExpression.getType());
            }
            if (right instanceof LiteralExpression) {
                return right;
            }
            if (right instanceof OperationExpression && (result = (operation = (OperationExpression)right).interpret(expressionBinding, instancesBinding)) instanceof LiteralExpression) {
                return result;
            }
        }
        return new NullLiteral();
    }
}

