/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.datatype.NullType;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.ListOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.list.PairOperation;
import org.dvare.expression.veriable.ListVariable;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.DataTypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.VALUES)
public class ValuesOperation
extends ListOperationExpression {
    private static Logger logger = LoggerFactory.getLogger(ValuesOperation.class);

    public ValuesOperation() {
        super(OperationType.VALUES);
    }

    public ValuesOperation(OperationType operationType) {
        super(operationType);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        List<Object> values = this.extractValues(expressionBinding, instancesBinding);
        if (values != null) {
            List<Object> includedValues = values;
            if (!this.rightOperand.isEmpty()) {
                if (this.rightOperand.size() == 1) {
                    Expression includeParam = (Expression)this.rightOperand.get(0);
                    includedValues = this.includedFilter(includeParam, expressionBinding, instancesBinding, values);
                } else if (this.rightOperand.size() == 2) {
                    Expression includeParam = (Expression)this.rightOperand.get(0);
                    Expression exculdeParam = (Expression)this.rightOperand.get(1);
                    includedValues = this.excludedFilter(includeParam, exculdeParam, expressionBinding, instancesBinding, values);
                }
            }
            return new ListLiteral(includedValues, (Class<? extends DataTypeExpression>)this.dataTypeExpression);
        }
        return new NullLiteral();
    }

    private List<Object> extractValues(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        List<Object> values = null;
        Expression left = this.leftOperand;
        if (left instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)left;
            if (variableExpression instanceof ListVariable) {
                this.dataTypeExpression = variableExpression.getType();
                Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
                variableExpression = VariableType.setVariableValue(variableExpression, instance);
                values = (ArrayList<Object>)((ListVariable)variableExpression).getValue();
            } else {
                ArrayList<Object> dataSet;
                this.dataTypeExpression = variableExpression.getType();
                Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
                if (instance instanceof List) {
                    dataSet = (ArrayList<Object>)instance;
                } else {
                    dataSet = new ArrayList<Object>();
                    dataSet.add(instance);
                }
                values = new ArrayList<Object>();
                for (Object e : dataSet) {
                    Object value = this.getValue(e, variableExpression.getName());
                    values.add(value);
                }
            }
        } else if (left instanceof ChainOperationExpression) {
            ChainOperationExpression operationExpression = (ChainOperationExpression)left;
            Expression expression = operationExpression.getLeftOperand();
            while (expression instanceof ChainOperationExpression) {
                expression = ((ChainOperationExpression)expression).getLeftOperand();
            }
            if (expression instanceof VariableExpression) {
                ArrayList<Object> dataSet;
                VariableExpression variableExpression = (VariableExpression)expression;
                String operandType = variableExpression.getOperandType();
                this.dataTypeExpression = variableExpression.getType();
                Object object = instancesBinding.getInstance(operandType);
                if (object instanceof List) {
                    dataSet = (ArrayList<Object>)object;
                } else {
                    dataSet = new ArrayList<Object>();
                    dataSet.add(object);
                }
                values = new ArrayList();
                for (Object e : dataSet) {
                    instancesBinding.addInstance(operandType, e);
                    LiteralExpression literalExpression = (LiteralExpression)operationExpression.interpret(expressionBinding, instancesBinding);
                    if (literalExpression.getType() != null && !literalExpression.getType().equals(NullType.class)) {
                        this.dataTypeExpression = literalExpression.getType();
                    }
                    values.add(literalExpression.getValue());
                }
                instancesBinding.addInstance(operandType, object);
            }
        } else if (left instanceof PairOperation) {
            values = this.pairValues(left, expressionBinding, instancesBinding);
        } else {
            values = this.buildValues(left, expressionBinding, instancesBinding);
            if (this.isPairList(values)) {
                values = this.extractPairValues(values);
            }
        }
        return values;
    }

    private List<Object> pairValues(Expression expression, ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        OperationExpression pairOperation;
        Object pairResultList;
        if ((expression instanceof PairOperation || expression instanceof ListOperationExpression) && (pairResultList = (pairOperation = (OperationExpression)expression).interpret(expressionBinding, instancesBinding)) instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)pairResultList;
            List pairList = (List)listLiteral.getValue();
            return this.extractPairValues(pairList);
        }
        return null;
    }

    private List<Object> extractPairValues(List pairList) {
        ArrayList<Object> pairValues = new ArrayList<Object>();
        for (Object pairObject : pairList) {
            if (!(pairObject instanceof Pair)) continue;
            Pair pair = (Pair)pairObject;
            if (this.dataTypeExpression == null) {
                DataType dataType = DataTypeMapping.getTypeMapping(pair.getValue().getClass());
                this.dataTypeExpression = DataTypeMapping.getDataTypeClass(dataType);
            }
            pairValues.add(pair.getValue());
        }
        return pairValues;
    }
}

