/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.utility;

import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;

@Operation(type=OperationType.DEF)
public class DefOperation
extends OperationExpression {
    public DefOperation() {
        super(OperationType.DEF);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        return pos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        TypeBinding typeBinding;
        String token = tokens[pos];
        if (!token.contains(":")) return pos;
        String[] parts = token.split(":");
        if (parts.length != 2) throw new ExpressionParseException("variable type not found");
        String name = parts[0].trim();
        String type = parts[1].trim();
        DataType dataType = DataType.valueOf(type);
        OperationExpression.TokenType tokenType = DefOperation.buildTokenType(name);
        if (contexts.getContext(tokenType.type) != null) {
            typeBinding = contexts.getContext(tokenType.type);
            if (typeBinding.getDataType(tokenType.token) != null) throw new ExpressionParseException(tokenType.type + " already contains " + tokenType.token + "variable ");
            typeBinding.addTypes(tokenType.token, (Object)dataType);
            contexts.addContext(tokenType.type, typeBinding);
        } else {
            typeBinding = new TypeBinding();
            typeBinding.addTypes(tokenType.token, (Object)dataType);
            contexts.addContext(tokenType.type, typeBinding);
        }
        VariableExpression variableExpression = VariableType.getVariableType(tokenType.token, dataType, tokenType.type);
        stack.push(variableExpression);
        return pos;
    }
}

