/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.utility;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.function.FunctionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.FunctionCallException;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.FunctionExpression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.StringType;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.validation.LeftPriority;
import org.dvare.expression.operation.validation.RightPriority;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.DataTypeMapping;
import org.dvare.util.TrimString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.FUNCTION)
public class Function
extends OperationExpression {
    private static Logger logger = LoggerFactory.getLogger(Function.class);

    public Function() {
        super(OperationType.FUNCTION);
    }

    public Function(OperationType operationType) {
        super(operationType);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        FunctionExpression functionExpression = (FunctionExpression)stack.pop();
        this.leftOperand = functionExpression;
        if (this.leftOperand == null) {
            String error = null;
            error = !functionExpression.getParameters().isEmpty() ? String.format("No Table Expression Found, %s is not  TableExpression", functionExpression.getParameters().get(functionExpression.getParameters().size() - 1).getClass().getSimpleName()) : "No Table Expression Found";
            logger.error(error);
            throw new ExpressionParseException(error);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("OperationExpression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        Stack<Expression> localStack = new Stack<Expression>();
        while (pos < tokens.length) {
            String token = tokens[pos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                if (op.getClass().equals(RightPriority.class)) {
                    ArrayList expressions = new ArrayList(localStack);
                    ArrayList<Expression> parameters = new ArrayList<Expression>();
                    FunctionExpression functionExpression = null;
                    for (Expression expression : expressions) {
                        if (expression instanceof FunctionExpression) {
                            functionExpression = (FunctionExpression)expression;
                            continue;
                        }
                        parameters.add(expression);
                    }
                    if (functionExpression != null) {
                        functionExpression.setParameters(parameters);
                        stack.push(functionExpression);
                    }
                    return pos;
                }
                if (!op.getClass().equals(LeftPriority.class)) {
                    pos = op.parse(tokens, pos, localStack, expressionBinding, contexts);
                }
            } else if (configurationRegistry.getFunction(token) != null) {
                FunctionBinding functionBinding = configurationRegistry.getFunction(token);
                FunctionExpression tableExpression = new FunctionExpression(token, functionBinding);
                localStack.add(tableExpression);
            } else {
                localStack.add(this.buildExpression(token, contexts));
            }
            ++pos;
        }
        throw new ExpressionParseException("Function Closing Bracket Not Found");
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        return this.interpretFunction(expressionBinding, instancesBinding);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected Object interpretFunction(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        functionExpression = (FunctionExpression)this.leftOperand;
        params = new Class[functionExpression.getParameters().size()];
        values = new Object[functionExpression.getParameters().size()];
        parameters = functionExpression.getBinding().getParameters();
        counter = 0;
        for (Expression expression : functionExpression.getParameters()) {
            dataType = parameters.get(counter);
            originalType = DataTypeMapping.getDataTypeMapping(dataType);
            if (expression instanceof OperationExpression) {
                operation = (OperationExpression)expression;
                literalExpression = (LiteralExpression)operation.interpret(expressionBinding, instancesBinding);
                paramsValue = this.buildLiteralParam(literalExpression, originalType);
                params[counter] = paramsValue.param;
                values[counter] = paramsValue.value;
            } else if (expression instanceof VariableExpression) {
                variableExpression = (VariableExpression)expression;
                instance = instancesBinding.getInstance(variableExpression.getOperandType());
                try {
                    variableDataType = this.toDataType(variableExpression.getType());
                    if (originalType == null) ** GOTO lbl57
                    if (originalType.isArray()) {
                        listValues = new ArrayList<T>();
                        if (instance instanceof Collection) {
                            dataSet = (ArrayList<Object>)instance;
                        } else {
                            dataSet = new ArrayList<Object>();
                            dataSet.add(instance);
                        }
                        for (E dataRow : dataSet) {
                            variableExpression = VariableType.setVariableValue(variableExpression, dataRow);
                            listValues.add(variableExpression.getValue());
                        }
                        type = DataTypeMapping.getDataTypeMapping(variableDataType);
                        typedArray = (Object[])Array.newInstance(type, dataSet.size());
                        value = listValues.toArray(typedArray);
                        params[counter] = originalType;
                        values[counter] = value;
                    }
                    if (instance instanceof Collection) {
                        dataSet = (List)instance;
                        if (!dataSet.isEmpty()) {
                            variableExpression = VariableType.setVariableValue(variableExpression, dataSet.get(0));
                        }
                    } else {
                        variableExpression = VariableType.setVariableValue(variableExpression, instance);
                    }
                    value = variableExpression.getValue();
                    params[counter] = originalType;
                    values[counter] = value;
                }
                catch (Exception e) {
                    throw new InterpretException(e);
                }
            } else if (expression instanceof LiteralExpression) {
                paramsValue = this.buildLiteralParam(expression, originalType);
                params[counter] = paramsValue.param;
                values[counter] = paramsValue.value;
            }
lbl57:
            // 7 sources

            ++counter;
        }
        return this.invokeFunction(functionExpression, params, values);
    }

    private ParamValue buildLiteralParam(Expression expression, Class originalType) throws InterpretException {
        ParamValue paramsValue = new ParamValue();
        if (expression instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)expression;
            try {
                DataType literalDataType = this.toDataType(listLiteral.getType());
                if (originalType.isArray()) {
                    Class type = DataTypeMapping.getDataTypeMapping(literalDataType);
                    Object[] typedArray = (Object[])Array.newInstance(type, (int)listLiteral.getSize());
                    Object[] value = ((List)listLiteral.getValue()).toArray(typedArray);
                    paramsValue.param = originalType;
                    paramsValue.value = value;
                }
                Object value = null;
                if (!listLiteral.isEmpty()) {
                    value = ((List)listLiteral.getValue()).get(0);
                }
                paramsValue.param = originalType;
                paramsValue.value = value;
            }
            catch (Exception e) {
                throw new InterpretException(e.getMessage(), e);
            }
        } else {
            LiteralExpression literalExpression = (LiteralExpression)expression;
            if (originalType.isArray()) {
                ArrayList<String> listValues = new ArrayList<String>();
                if (literalExpression.getType().equals(StringType.class)) {
                    Object value = literalExpression.getValue();
                    if (value != null) {
                        listValues.add(TrimString.trim(value.toString()));
                    }
                } else {
                    listValues.add((String)literalExpression.getValue());
                }
                Class type = DataTypeMapping.getDataTypeMapping(this.toDataType(literalExpression.getType()));
                Object[] typedArray = (Object[])Array.newInstance(type, 1);
                Object[] value = listValues.toArray(typedArray);
                paramsValue.param = originalType;
                paramsValue.value = value;
            } else {
                paramsValue.param = DataTypeMapping.getDataTypeMapping(this.toDataType(literalExpression.getType()));
                if (paramsValue.param == null) {
                    paramsValue.param = originalType;
                }
                if (literalExpression.getType().equals(StringType.class)) {
                    Object value = literalExpression.getValue();
                    if (value != null) {
                        paramsValue.value = TrimString.trim(value.toString());
                    }
                } else {
                    paramsValue.value = literalExpression.getValue();
                }
            }
        }
        return paramsValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object invokeFunction(FunctionExpression functionExpression, Class<?>[] params, Object[] values) throws InterpretException {
        try {
            Object value;
            Method method;
            FunctionBinding functionBinding = functionExpression.getBinding();
            String functionName = functionExpression.getName();
            Class functionClass = functionBinding.getFunctionClass();
            Object classInstance = functionBinding.getFunctionInstance();
            if (functionClass != null && classInstance == null) {
                classInstance = functionClass.newInstance();
                method = MethodUtils.getAccessibleMethod((Class)functionClass, (String)functionName, (Class[])params);
                if (method == null) {
                    method = MethodUtils.getAccessibleMethod((Class)functionClass, (String)functionBinding.getMethodName(), (Class[])this.castParams(params));
                }
                if (method == null) throw new InterpretException("Function \"" + functionName + "\" parameter not match near " + this.toString());
                value = method.invoke(classInstance, values);
            } else {
                method = MethodUtils.getAccessibleMethod(classInstance.getClass(), (String)functionName, (Class[])params);
                if (method == null) {
                    method = MethodUtils.getAccessibleMethod((Class)functionClass, (String)functionBinding.getMethodName(), (Class[])this.castParams(params));
                }
                if (method == null) throw new InterpretException("Function \"" + functionName + "\" parameter not match near " + this.toString());
                value = method.invoke(classInstance, values);
            }
            if (value == null) {
                return new NullLiteral();
            }
            if (value instanceof List) {
                List list = (List)value;
                return new ListLiteral(list, functionExpression.binding.getReturnType());
            }
            if (!value.getClass().isArray()) return LiteralType.getLiteralExpression(value, functionExpression.binding.getReturnType());
            return new ListLiteral(Arrays.asList(value), functionExpression.binding.getReturnType());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (!(target instanceof InterpretException)) throw new InterpretException(e.getMessage(), e);
            throw new FunctionCallException(target.getMessage(), target);
        }
        catch (Exception e) {
            throw new InterpretException(e.getMessage(), e);
        }
    }

    private Class[] castParams(Class[] params) throws Exception {
        for (int i = 0; i < params.length; ++i) {
            Class aClass;
            Class param = params[i];
            if (param.isPrimitive() || !param.equals(Integer.class) && !param.equals(Float.class) && !param.equals(Boolean.class) && !param.equals(Double.class) && !param.getClass().equals(Long.class) || (aClass = (Class)FieldUtils.readStaticField((Class)params[i], (String)"TYPE", (boolean)true)) == null) continue;
            params[i] = aClass;
        }
        return params;
    }

    @Override
    public String toString() {
        if (this.leftOperand instanceof FunctionExpression) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("function");
            stringBuilder.append("(");
            FunctionExpression functionExpression = (FunctionExpression)this.leftOperand;
            stringBuilder.append(functionExpression.getName());
            stringBuilder.append(", ");
            for (Expression expression : functionExpression.getParameters()) {
                stringBuilder.append(expression);
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return super.toString();
    }

    private class ParamValue {
        Class<?> param;
        Object value;

        private ParamValue() {
        }
    }
}

