/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.utility;

import java.util.ArrayList;
import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.NamedExpression;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.validation.RightPriority;
import org.dvare.parser.ExpressionTokenizer;

@Operation(type=OperationType.GET_EXP)
public class GetExpOperation
extends OperationExpression {
    public GetExpOperation() {
        super(OperationType.GET_EXP);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        if (this.leftOperand != null) {
            String name = ((NamedExpression)this.leftOperand).getName();
            if (expressionBinding == null || expressionBinding.getExpression(name) == null) {
                throw new ExpressionParseException("Expression " + name + " not registered at " + ExpressionTokenizer.toString(tokens, pos));
            }
        }
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        Stack<NamedExpression> localStack = new Stack<NamedExpression>();
        while (pos < tokens.length) {
            String token = tokens[pos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                if (op instanceof RightPriority) {
                    Expression namedExpression;
                    ArrayList expressionList = new ArrayList(localStack);
                    if (expressionList.size() == 1 && (namedExpression = (Expression)expressionList.get(0)) instanceof NamedExpression) {
                        this.leftOperand = namedExpression;
                    }
                    return pos;
                }
            } else {
                localStack.add(new NamedExpression(token));
            }
            ++pos;
        }
        return pos;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        String expressionName = ((NamedExpression)this.leftOperand).getName();
        if (expressionBinding != null) {
            Expression expression = expressionBinding.getExpression(expressionName);
            return expression.interpret(expressionBinding, instancesBinding);
        }
        return new NullLiteral();
    }
}

