/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.utility;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.function.FunctionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.FunctionExpression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.utility.Function;
import org.dvare.expression.operation.validation.LeftPriority;
import org.dvare.expression.operation.validation.RightPriority;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.DataTypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.INVOKE)
public class Invoke
extends Function {
    private static Logger logger = LoggerFactory.getLogger(Invoke.class);

    public Invoke() {
        super(OperationType.INVOKE);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        if (logger.isDebugEnabled()) {
            logger.debug("OperationExpression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        Stack<Expression> localStack = new Stack<Expression>();
        while (pos < tokens.length) {
            String token = tokens[pos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (token.contains("#")) {
                String[] parts = token.split("#");
                String variable = parts[0];
                this.rightOperand = this.buildExpression(variable, contexts);
                String functionName = parts[1];
                FunctionBinding functionBinding = new FunctionBinding(functionName, null, null, null, null);
                this.leftOperand = new FunctionExpression(functionName, functionBinding);
            } else if (op != null) {
                if (op.getClass().equals(RightPriority.class)) {
                    FunctionExpression functionExpression;
                    ArrayList expressions = new ArrayList(localStack);
                    ArrayList<Expression> parameters = new ArrayList<Expression>();
                    if (this.leftOperand != null) {
                        functionExpression = (FunctionExpression)this.leftOperand;
                        for (Expression expression : expressions) {
                            parameters.add(expression);
                        }
                    } else {
                        throw new ExpressionParseException("Function Name not Found");
                    }
                    functionExpression.setParameters(parameters);
                    stack.push(functionExpression);
                    return pos;
                }
                if (!op.getClass().equals(LeftPriority.class)) {
                    pos = op.parse(tokens, pos, localStack, expressionBinding, contexts);
                }
            } else {
                localStack.add(this.buildExpression(token, contexts));
            }
            ++pos;
        }
        throw new ExpressionParseException("Function Closing Bracket Not Found");
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Object value = null;
        if (this.rightOperand instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)this.rightOperand;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            variableExpression = VariableType.setVariableValue(variableExpression, instance);
            value = variableExpression.getValue();
        } else if (this.rightOperand instanceof LiteralExpression) {
            value = ((LiteralExpression)this.rightOperand).getValue();
        }
        if (value != null) {
            ArrayList<DataType> parameters;
            Class<?> functionClass = value.getClass();
            FunctionExpression functionExpression = (FunctionExpression)this.leftOperand;
            FunctionBinding functionBinding = functionExpression.getBinding();
            functionBinding.setFunctionClass(functionClass);
            functionBinding.setFunctionInstance(value);
            Method method = MethodUtils.getAccessibleMethod(functionClass, (String)functionBinding.getMethodName(), (Class[])new Class[0]);
            if (method == null) {
                parameters = new ArrayList<DataType>();
                for (Expression expression : functionExpression.getParameters()) {
                    Object interpret = expression.interpret(expressionBinding, instancesBinding);
                    if (!(interpret instanceof LiteralExpression)) continue;
                    Object value1 = ((LiteralExpression)interpret).getValue();
                    parameters.add((DataType)((Object)value1.getClass()));
                }
                Class[] params = parameters.toArray(new Class[parameters.size()]);
                method = MethodUtils.getAccessibleMethod(functionClass, (String)functionBinding.getMethodName(), (Class[])params);
                if (method == null) {
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i].isPrimitive()) continue;
                        try {
                            Class aClass;
                            params[i] = aClass = (Class)FieldUtils.readStaticField((Class)params[i], (String)"TYPE", (boolean)true);
                            continue;
                        }
                        catch (IllegalAccessException aClass) {
                            // empty catch block
                        }
                    }
                    method = MethodUtils.getAccessibleMethod(functionClass, (String)functionBinding.getMethodName(), (Class[])params);
                }
            }
            if (method != null) {
                DataType returnType;
                Class<? extends DataTypeExpression> dataTypeExpressionClass;
                parameters = new ArrayList();
                for (Class<?> type : method.getParameterTypes()) {
                    DataType dataType = DataTypeMapping.getTypeMapping(type);
                    parameters.add(dataType);
                }
                functionBinding.setParameters(parameters);
                Class<?> returnClass = method.getReturnType();
                if (returnClass != null && !returnClass.equals(Void.class) && (dataTypeExpressionClass = DataTypeMapping.getDataTypeClass(returnType = DataTypeMapping.getTypeMapping(returnClass))) != null) {
                    functionBinding.setReturnType(dataTypeExpressionClass);
                }
            } else {
                throw new InterpretException("Method Param not match");
            }
        }
        return this.interpretFunction(expressionBinding, instancesBinding);
    }
}

