/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.utility;

import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;

@Operation(type=OperationType.LET)
public class LetOperation
extends OperationExpression {
    public LetOperation() {
        super(OperationType.LET);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        String[] parts;
        String token = tokens[pos];
        if (token.contains(":") && (parts = token.split(":")).length == 2) {
            TypeBinding typeBinding;
            String name = parts[0].trim();
            String type = parts[1].trim();
            DataType dataType = DataType.valueOf(type);
            if (contexts.getContext("temp") == null) {
                typeBinding = new TypeBinding();
                typeBinding.addTypes(name, (Object)dataType);
                contexts.addContext("temp", typeBinding);
            } else {
                typeBinding = contexts.getContext("temp");
                typeBinding.addTypes(name, (Object)dataType);
                contexts.addContext("temp", typeBinding);
            }
            VariableExpression variableExpression = VariableType.getVariableType(name, dataType, "temp");
            stack.push(variableExpression);
        }
        return pos;
    }
}

