/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.utility;

import java.util.ArrayList;
import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.NamedExpression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.validation.LeftPriority;
import org.dvare.expression.operation.validation.RightPriority;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.TypeFinder;

@Operation(type=OperationType.PUT_EXP)
public class PutExpOperation
extends OperationExpression {
    public PutExpOperation() {
        super(OperationType.PUT_EXP);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        Stack<Expression> localStack = new Stack<Expression>();
        while (pos < tokens.length) {
            String token = tokens[pos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                if (op instanceof RightPriority) {
                    Expression namedExpression;
                    ArrayList expressionList = new ArrayList(localStack);
                    if (expressionList.size() == 2 && (namedExpression = (Expression)expressionList.get(0)) instanceof NamedExpression) {
                        Expression expression = (Expression)expressionList.get(1);
                        if (expressionBinding != null) {
                            expressionBinding.addExpression(((NamedExpression)namedExpression).getName(), expression);
                        } else {
                            throw new ExpressionParseException("Exression Binding is null");
                        }
                    }
                    return pos;
                }
                if (!(op instanceof LeftPriority)) {
                    pos = op.parse(tokens, pos, localStack, expressionBinding, contexts);
                }
            } else {
                OperationExpression.TokenType tokenType = PutExpOperation.findDataObject(token, contexts);
                if (tokenType.type != null && contexts.getContext(tokenType.type) != null && TypeFinder.findType(tokenType.token, contexts.getContext(tokenType.type)) != null) {
                    TypeBinding typeBinding = contexts.getContext(tokenType.type);
                    DataType variableType = TypeFinder.findType(tokenType.token, typeBinding);
                    VariableType.getVariableType(tokenType.token, variableType, tokenType.type);
                    localStack.add(this.buildExpression(token, contexts));
                } else {
                    localStack.add(new NamedExpression(token));
                }
            }
            ++pos;
        }
        return pos;
    }
}

