/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.validation;

import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.validation.RightPriority;

@Operation(type=OperationType.LEFT_PRIORITY)
public class LeftPriority
extends OperationExpression {
    public LeftPriority() {
        super(OperationType.LEFT_PRIORITY);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        while (!stack.peek().getClass().equals(RightPriority.class)) {
            pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        }
        if (stack.peek().getClass().equals(RightPriority.class)) {
            stack.pop();
        }
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        while (pos < tokens.length) {
            OperationExpression op = configurationRegistry.getOperation(tokens[pos]);
            if (op != null) {
                if (op.getClass().equals(RightPriority.class)) {
                    stack.push(op);
                    return pos;
                }
                pos = op.parse(tokens, pos, stack, expressionBinding, contexts);
            }
            ++pos;
        }
        return pos;
    }
}

