/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.BooleanType;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.BooleanLiteral;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ListOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.validation.LeftPriority;
import org.dvare.expression.operation.validation.RightPriority;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.TrimString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.Match)
public class Match
extends OperationExpression {
    private static Logger logger = LoggerFactory.getLogger(Match.class);
    protected List<Expression> leftOperand;

    public Match() {
        super(OperationType.Match);
    }

    public Match(OperationType operationType) {
        super(operationType);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contextss) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contextss);
        this.computeParam(this.leftOperand);
        stack.push(this);
        return pos;
    }

    private void computeParam(List<Expression> expressions) throws ExpressionParseException {
        if (expressions == null || expressions.size() < 2) {
            String error = "Match Operation minimum two parameter";
            logger.error(error);
            throw new ExpressionParseException(error);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("OperationExpression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        Stack<Expression> localStack = new Stack<Expression>();
        while (pos < tokens.length) {
            String token = tokens[pos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                if (op instanceof RightPriority) {
                    this.leftOperand = new ArrayList<Expression>(localStack);
                    return pos;
                }
                if (!(op instanceof LeftPriority)) {
                    pos = op.parse(tokens, pos, localStack, expressionBinding, contexts);
                }
            } else {
                localStack.add(this.buildExpression(token, contexts));
            }
            ++pos;
        }
        return pos;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        List<Expression> expressions = this.leftOperand;
        Expression valueParam = expressions.get(0);
        List values = this.buildValues(expressionBinding, instancesBinding, valueParam);
        DataType dataType = this.toDataType(this.dataTypeExpression);
        Expression paramsExpression = expressions.get(1);
        List matchParams = this.buildMatchParams(expressionBinding, instancesBinding, paramsExpression);
        Boolean insideCombination = false;
        Boolean combinationExist = false;
        if (expressions.size() == 2) {
            combinationExist = true;
        } else {
            if (expressions.size() > 2 && expressions.get(2) instanceof BooleanLiteral) {
                insideCombination = (Boolean)((BooleanLiteral)expressions.get(2)).getValue();
            }
            if (expressions.size() > 3 && expressions.get(3) instanceof BooleanLiteral) {
                combinationExist = (Boolean)((BooleanLiteral)expressions.get(3)).getValue();
            }
        }
        return this.match(dataType, values, matchParams, insideCombination, combinationExist);
    }

    protected List buildValues(ExpressionBinding expressionBinding, InstancesBinding instancesBinding, Expression valueParam) throws InterpretException {
        ListLiteral listLiteral;
        Object interpret;
        List values = new ArrayList();
        if (valueParam instanceof VariableExpression) {
            ArrayList<Object> dataSet;
            VariableExpression variableExpression = (VariableExpression)valueParam;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                dataSet = (ArrayList<Object>)instance;
            } else {
                dataSet = new ArrayList<Object>();
                dataSet.add(instance);
            }
            this.dataTypeExpression = variableExpression.getType();
            for (Object e : dataSet) {
                variableExpression = VariableType.setVariableValue(variableExpression, e);
                values.add(variableExpression.getValue());
            }
        } else if (valueParam instanceof ListOperationExpression && (interpret = valueParam.interpret(expressionBinding, instancesBinding)) instanceof ListLiteral && (listLiteral = (ListLiteral)interpret).getValue() != null) {
            values = (List)listLiteral.getValue();
            this.dataTypeExpression = listLiteral.getType();
        }
        return values;
    }

    protected List buildMatchParams(ExpressionBinding expressionBinding, InstancesBinding instancesBinding, Expression paramsExpression) throws InterpretException {
        ArrayList matchParams = null;
        if (paramsExpression instanceof LiteralExpression) {
            matchParams = this.buildMatchParams((LiteralExpression)paramsExpression);
        } else if (paramsExpression instanceof OperationExpression) {
            OperationExpression operationExpression = (OperationExpression)paramsExpression;
            Object interpret = operationExpression.interpret(expressionBinding, instancesBinding);
            if (interpret instanceof LiteralExpression) {
                matchParams = this.buildMatchParams((LiteralExpression)interpret);
            }
        } else if (paramsExpression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)paramsExpression;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            variableExpression = VariableType.setVariableValue(variableExpression, instance);
            matchParams = new ArrayList();
            matchParams.add(variableExpression.getValue());
        }
        return matchParams;
    }

    protected LiteralExpression match(DataType dataType, List values, List matchParams, Boolean insideCombination, Boolean combinationExist) throws InterpretException {
        if (dataType != null && matchParams != null && values != null) {
            if (matchParams.isEmpty() && values.isEmpty()) {
                return LiteralType.getLiteralExpression((Object)true, BooleanType.class);
            }
            switch (dataType) {
                case StringType: {
                    try {
                        List stringValues = values;
                        List matchParamsStringValues = matchParams;
                        if (insideCombination.booleanValue() && combinationExist.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)(this.insideCombinationString(stringValues, matchParamsStringValues) != false && this.combinationExistString(stringValues, matchParamsStringValues) != false ? 1 : 0), BooleanType.class);
                        }
                        if (insideCombination.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)this.insideCombinationString(stringValues, matchParamsStringValues), BooleanType.class);
                        }
                        if (combinationExist.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)this.combinationExistString(stringValues, matchParamsStringValues), BooleanType.class);
                        }
                    }
                    catch (ClassCastException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                case BooleanType: {
                    try {
                        List booleanValues = values;
                        List matchParamsBooleanValues = matchParams;
                        if (insideCombination.booleanValue() && combinationExist.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)(this.insideCombinationBoolean(booleanValues, matchParamsBooleanValues) != false && booleanValues.containsAll(matchParamsBooleanValues) ? 1 : 0), BooleanType.class);
                        }
                        if (insideCombination.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)this.insideCombinationBoolean(booleanValues, matchParamsBooleanValues), BooleanType.class);
                        }
                        if (combinationExist.booleanValue()) {
                            boolean result = booleanValues.containsAll(matchParamsBooleanValues);
                            return LiteralType.getLiteralExpression((Object)result, BooleanType.class);
                        }
                    }
                    catch (ClassCastException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                case IntegerType: {
                    List integerValues = values;
                    try {
                        List matchParamsIntegerValues = matchParams;
                        if (insideCombination.booleanValue() && combinationExist.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)(this.insideCombinationInteger(integerValues, matchParamsIntegerValues) != false && integerValues.containsAll(matchParamsIntegerValues) ? 1 : 0), BooleanType.class);
                        }
                        if (insideCombination.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)this.insideCombinationInteger(integerValues, matchParamsIntegerValues), BooleanType.class);
                        }
                        if (combinationExist.booleanValue()) {
                            boolean result = integerValues.containsAll(matchParamsIntegerValues);
                            return LiteralType.getLiteralExpression((Object)result, BooleanType.class);
                        }
                    }
                    catch (ClassCastException e) {
                        List combList = matchParams;
                        boolean result = integerValues.containsAll(combList);
                        return LiteralType.getLiteralExpression((Object)result, BooleanType.class);
                    }
                }
                case FloatType: {
                    List floatValues = values;
                    try {
                        List matchParamsFloatValues = matchParams;
                        if (insideCombination.booleanValue() && combinationExist.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)(this.insideCombinationFloat(floatValues, matchParamsFloatValues) != false && floatValues.containsAll(matchParamsFloatValues) ? 1 : 0), BooleanType.class);
                        }
                        if (insideCombination.booleanValue()) {
                            return LiteralType.getLiteralExpression((Object)this.insideCombinationFloat(floatValues, matchParamsFloatValues), BooleanType.class);
                        }
                        if (combinationExist.booleanValue()) {
                            boolean result = floatValues.containsAll(matchParamsFloatValues);
                            return LiteralType.getLiteralExpression((Object)result, BooleanType.class);
                        }
                        break;
                    }
                    catch (ClassCastException e) {
                        List combList = matchParams;
                        boolean result = floatValues.containsAll(combList);
                        return LiteralType.getLiteralExpression((Object)result, BooleanType.class);
                    }
                }
            }
        }
        return LiteralType.getLiteralExpression((Object)false, BooleanType.class);
    }

    private Boolean insideCombinationString(List<String> stringValues, List<String> matchParamsStringValues) throws InterpretException {
        for (String value : stringValues) {
            if (matchParamsStringValues.contains(value = TrimString.trim(value))) continue;
            return false;
        }
        return true;
    }

    private Boolean combinationExistString(List<String> stringValues, List<String> matchParamsStringValues) throws InterpretException {
        ArrayList<String> stringValuesTrimed = new ArrayList<String>();
        for (String value : stringValues) {
            if (value != null) {
                stringValuesTrimed.add(TrimString.trim(value));
                continue;
            }
            stringValuesTrimed.add(null);
        }
        ArrayList<String> matchParamsStringValuesTrimed = new ArrayList<String>();
        for (String value : matchParamsStringValues) {
            if (value != null) {
                matchParamsStringValuesTrimed.add(TrimString.trim(value));
                continue;
            }
            matchParamsStringValuesTrimed.add(null);
        }
        return stringValuesTrimed.containsAll(matchParamsStringValuesTrimed);
    }

    private Boolean insideCombinationBoolean(List<Boolean> booleanValues, List<Boolean> matchParamsBooleanValues) throws InterpretException {
        for (Boolean value : booleanValues) {
            if (matchParamsBooleanValues.contains(value)) continue;
            return false;
        }
        return true;
    }

    private Boolean insideCombinationInteger(List<Integer> integerValues, List<Integer> matchParamsIntegerValues) throws InterpretException {
        for (Integer value : integerValues) {
            if (matchParamsIntegerValues.contains(value)) continue;
            return false;
        }
        return true;
    }

    private Boolean insideCombinationFloat(List<Float> floatValues, List<Float> matchParamsFloatValues) throws InterpretException {
        for (Float value : floatValues) {
            if (matchParamsFloatValues.contains(value)) continue;
            return false;
        }
        return true;
    }

    private List buildMatchParams(LiteralExpression literalExpression) {
        List<Object> matchParams = new ArrayList();
        if (literalExpression instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)literalExpression;
            if (listLiteral.getValue() != null) {
                matchParams = (List)listLiteral.getValue();
            }
        } else if (!(literalExpression instanceof NullLiteral)) {
            matchParams.add(literalExpression.getValue());
        }
        return matchParams;
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append(this.operationType.getSymbols().get(0));
        toStringBuilder.append("( ");
        if (this.leftOperand != null && !this.leftOperand.isEmpty()) {
            for (Expression expression : this.leftOperand) {
                toStringBuilder.append(expression.toString());
                toStringBuilder.append(" , ");
            }
        }
        toStringBuilder.append(" )");
        return toStringBuilder.toString();
    }
}

