/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.veriable;

import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralType;

public abstract class VariableExpression<T>
extends Expression {
    protected String name;
    protected Class<? extends DataTypeExpression> type;
    protected String operandType;
    protected T value;

    VariableExpression(String name, Class<? extends DataTypeExpression> type) {
        this(name, type, null);
    }

    VariableExpression(String name, Class<? extends DataTypeExpression> type, T value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        return LiteralType.getLiteralExpression(this.value, this.type);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<? extends DataTypeExpression> getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getOperandType() {
        return this.operandType;
    }

    public void setOperandType(String operandType) {
        this.operandType = operandType;
    }
}

