/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.veriable;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dvare.annotations.Type;
import org.dvare.exceptions.interpreter.IllegalPropertyValueException;
import org.dvare.exceptions.parser.IllegalPropertyException;
import org.dvare.expression.datatype.BooleanType;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DateTimeType;
import org.dvare.expression.datatype.DateType;
import org.dvare.expression.datatype.FloatType;
import org.dvare.expression.datatype.IntegerType;
import org.dvare.expression.datatype.SimpleDateType;
import org.dvare.expression.datatype.StringType;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.veriable.BooleanVariable;
import org.dvare.expression.veriable.DateTimeVariable;
import org.dvare.expression.veriable.DateVariable;
import org.dvare.expression.veriable.FloatVariable;
import org.dvare.expression.veriable.IntegerVariable;
import org.dvare.expression.veriable.ListVariable;
import org.dvare.expression.veriable.RegexVariable;
import org.dvare.expression.veriable.SimpleDateVariable;
import org.dvare.expression.veriable.StringVariable;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.util.ValueFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableType {
    private static Logger logger = LoggerFactory.getLogger(VariableType.class);

    public static VariableExpression getVariableType(String name, DataType type, String operandType) throws IllegalPropertyException {
        VariableExpression variableExpression = VariableType.getVariableType(name, type);
        variableExpression.setOperandType(operandType);
        return variableExpression;
    }

    public static VariableExpression getVariableType(String name, DataType type) throws IllegalPropertyException {
        VariableExpression variableExpression;
        if (name == null) {
            throw new IllegalPropertyException("The provided string must not be null");
        }
        if (type == null) {
            throw new IllegalPropertyException("The provided type must not be null");
        }
        switch (type) {
            case BooleanType: {
                variableExpression = new BooleanVariable(name);
                break;
            }
            case BooleanListType: {
                variableExpression = new ListVariable(name, BooleanType.class);
                break;
            }
            case FloatType: {
                variableExpression = new FloatVariable(name);
                break;
            }
            case FloatListType: {
                variableExpression = new ListVariable(name, FloatType.class);
                break;
            }
            case IntegerType: {
                variableExpression = new IntegerVariable(name);
                break;
            }
            case IntegerListType: {
                variableExpression = new ListVariable(name, IntegerType.class);
                break;
            }
            case StringType: {
                variableExpression = new StringVariable(name);
                break;
            }
            case StringListType: {
                variableExpression = new ListVariable(name, StringType.class);
                break;
            }
            case DateTimeType: {
                variableExpression = new DateTimeVariable(name);
                break;
            }
            case DateTimeListType: {
                variableExpression = new ListVariable(name, DateTimeType.class);
                break;
            }
            case DateType: {
                variableExpression = new DateVariable(name);
                break;
            }
            case DateListType: {
                variableExpression = new ListVariable(name, DateType.class);
                break;
            }
            case SimpleDateType: {
                variableExpression = new SimpleDateVariable(name);
                break;
            }
            case SimpleDateListType: {
                variableExpression = new ListVariable(name, SimpleDateType.class);
                break;
            }
            case RegexType: {
                variableExpression = new StringVariable(name);
                break;
            }
            default: {
                String message = String.format("Type of Variable Expression {} not found", name);
                logger.error(message);
                throw new IllegalPropertyException(message);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Variable  Expression Veriable: {} [{}]", (Object)variableExpression.getClass().getSimpleName(), (Object)variableExpression.getName());
        }
        return variableExpression;
    }

    public static VariableExpression setVariableValue(VariableExpression variable, Object object) throws IllegalPropertyValueException {
        Object value = ValueFinder.findValue(variable.getName(), object);
        return VariableType.setValue(variable, value);
    }

    private static VariableExpression setValue(VariableExpression variable, Object value) throws IllegalPropertyValueException {
        if (value == null) {
            variable.setValue(null);
            return variable;
        }
        if (variable.getType().isAnnotationPresent(Type.class)) {
            Type type = variable.getType().getAnnotation(Type.class);
            DataType dataType = type.dataType();
            switch (dataType) {
                case BooleanType: {
                    if (variable instanceof ListVariable) {
                        ListVariable listVariable = (ListVariable)variable;
                        if (value instanceof List) {
                            listVariable.setValue((List)value);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        if (value instanceof Boolean) {
                            values.add(value);
                        }
                        listVariable.setValue(values);
                        break;
                    }
                    if (!(variable instanceof BooleanVariable)) break;
                    BooleanVariable booleanVariable = (BooleanVariable)variable;
                    if (value instanceof Boolean) {
                        booleanVariable.setValue((Boolean)value);
                        break;
                    }
                    if (value.toString().equals("")) {
                        booleanVariable.setValue(false);
                        break;
                    }
                    booleanVariable.setValue(Boolean.parseBoolean((String)value));
                    break;
                }
                case FloatType: {
                    if (variable instanceof ListVariable) {
                        ListVariable listVariable = (ListVariable)variable;
                        if (value instanceof List) {
                            listVariable.setValue((List)value);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        if (value instanceof Float) {
                            values.add(value);
                        } else {
                            values.add(Float.valueOf(Float.parseFloat(value.toString())));
                        }
                        listVariable.setValue(values);
                        break;
                    }
                    if (!(variable instanceof FloatVariable)) break;
                    FloatVariable floatVariable = (FloatVariable)variable;
                    try {
                        if (value instanceof Float) {
                            floatVariable.setValue((Float)value);
                            break;
                        }
                        if (value.toString().equals("")) {
                            floatVariable.setValue(Float.valueOf(0.0f));
                            break;
                        }
                        floatVariable.setValue(Float.valueOf(Float.parseFloat(value.toString())));
                        break;
                    }
                    catch (NumberFormatException e) {
                        String message = String.format("Unable to Parse literal %s to Float", value);
                        logger.error(message);
                        throw new IllegalPropertyValueException(message);
                    }
                }
                case IntegerType: {
                    if (variable instanceof ListVariable) {
                        ListVariable listVariable = (ListVariable)variable;
                        if (value instanceof List) {
                            listVariable.setValue((List)value);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        if (value instanceof Integer) {
                            values.add(value);
                        } else {
                            values.add(Integer.parseInt((String)value));
                        }
                        listVariable.setValue(values);
                        break;
                    }
                    if (!(variable instanceof IntegerVariable)) break;
                    IntegerVariable integerVariable = (IntegerVariable)variable;
                    try {
                        if (value instanceof Integer) {
                            integerVariable.setValue((Integer)value);
                            break;
                        }
                        if (value.toString().equals("")) {
                            integerVariable.setValue(0);
                            break;
                        }
                        integerVariable.setValue(Integer.parseInt((String)value));
                        break;
                    }
                    catch (NumberFormatException e) {
                        String message = String.format("Unable to Parse literal %s to Integer", value);
                        logger.error(message);
                        throw new IllegalPropertyValueException(message);
                    }
                }
                case StringType: {
                    if (variable instanceof ListVariable) {
                        ListVariable listVariable = (ListVariable)variable;
                        if (value instanceof List) {
                            listVariable.setValue((List)value);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        values.add(value);
                        listVariable.setValue(values);
                        break;
                    }
                    if (!(variable instanceof StringVariable)) break;
                    StringVariable stringVariable = (StringVariable)variable;
                    if (value instanceof String) {
                        stringVariable.setValue((String)value);
                        break;
                    }
                    stringVariable.setValue(value.toString());
                    break;
                }
                case DateTimeType: {
                    if (variable instanceof ListVariable) {
                        ListVariable listVariable = (ListVariable)variable;
                        if (value instanceof List) {
                            listVariable.setValue((List)value);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        if (value instanceof LocalDateTime) {
                            values.add(value);
                        }
                        listVariable.setValue(values);
                        break;
                    }
                    if (!(variable instanceof DateTimeVariable)) break;
                    DateTimeVariable dateTimeVariable = (DateTimeVariable)variable;
                    LocalDateTime localDateTime = null;
                    if (value instanceof LocalDateTime) {
                        localDateTime = (LocalDateTime)value;
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    } else {
                        String newValue = (String)value;
                        if (!newValue.isEmpty()) {
                            try {
                                localDateTime = LocalDateTime.parse(newValue, LiteralType.dateTimeFormat);
                            }
                            catch (Exception e) {
                                try {
                                    localDateTime = LocalDateTime.parse(newValue, LiteralType.defaultFormat);
                                }
                                catch (Exception ex) {
                                    String message = String.format("Unable to Parse literal %s to DateTime", newValue);
                                    logger.error(message);
                                    throw new IllegalPropertyValueException(message);
                                }
                            }
                        }
                    }
                    dateTimeVariable.setValue(localDateTime);
                    break;
                }
                case DateType: {
                    if (variable instanceof ListVariable) {
                        ListVariable listVariable = (ListVariable)variable;
                        if (value instanceof List) {
                            listVariable.setValue((List)value);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        if (value instanceof LocalDate) {
                            values.add(value);
                        }
                        listVariable.setValue(values);
                        break;
                    }
                    if (!(variable instanceof DateVariable)) break;
                    DateVariable dateVariable = (DateVariable)variable;
                    LocalDate localDate = null;
                    if (value instanceof LocalDate) {
                        localDate = (LocalDate)value;
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    } else {
                        String newValue = (String)value;
                        if (!newValue.isEmpty()) {
                            try {
                                localDate = LocalDate.parse(newValue, LiteralType.dateFormat);
                            }
                            catch (Exception e) {
                                try {
                                    localDate = LocalDate.parse(newValue, LiteralType.defaultFormat);
                                }
                                catch (Exception ex) {
                                    String message = String.format("Unable to Parse literal %s to Date", newValue);
                                    logger.error(message);
                                    throw new IllegalPropertyValueException(message);
                                }
                            }
                        }
                    }
                    dateVariable.setValue(localDate);
                    break;
                }
                case SimpleDateType: {
                    if (variable instanceof ListVariable) {
                        ListVariable listVariable = (ListVariable)variable;
                        if (value instanceof List) {
                            listVariable.setValue((List)value);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        if (value instanceof Date) {
                            values.add(value);
                        }
                        listVariable.setValue(values);
                        break;
                    }
                    if (!(variable instanceof SimpleDateVariable)) break;
                    SimpleDateVariable dateVariable = (SimpleDateVariable)variable;
                    Date date = null;
                    if (value instanceof LocalDate) {
                        LocalDate localDate = (LocalDate)value;
                        date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    } else if (value instanceof LocalDateTime) {
                        LocalDateTime localDateTime = (LocalDateTime)value;
                        date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
                    } else if (value instanceof Date) {
                        date = (Date)value;
                    } else {
                        String newValue = (String)value;
                        if (!newValue.isEmpty()) {
                            try {
                                date = SimpleDateType.dateFormat.parse(newValue);
                            }
                            catch (Exception e) {
                                try {
                                    date = SimpleDateType.dateTimeFormat.parse(newValue);
                                }
                                catch (ParseException ex) {
                                    String message = String.format("Unable to Parse literal %s to Date", newValue);
                                    logger.error(message);
                                    throw new IllegalPropertyValueException(message);
                                }
                            }
                        }
                    }
                    dateVariable.setValue(date);
                    break;
                }
                case RegexType: {
                    if (!(variable instanceof RegexVariable)) break;
                    RegexVariable regexVariable = (RegexVariable)variable;
                    regexVariable.setValue(value.toString());
                }
            }
        }
        return variable;
    }
}

