/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dvare.parser.ExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTokenizer {
    private static Logger logger = LoggerFactory.getLogger(ExpressionParser.class);

    public static void main(String[] args) throws IOException {
        String exp = "Variable1 = (7 + 3) And Variable1 <> ( 30 - 10) And Variable2 = (4 * 5) And Variable8 = 'A'  And Variable1 = ( Variable2 / 2 ) And Variable1 = ( Variable1 min Variable2 ) And Variable2 = ( Variable1 max Variable2 )";
        for (String token : ExpressionTokenizer.toToken(exp)) {
            System.out.println(token);
        }
    }

    public static String[] toToken(String expr) {
        String[] splits = new String[]{"\\s", "\\,", "\\->"};
        return ExpressionTokenizer.toToken(expr, splits);
    }

    public static String[] toToken(String expr, String[] splits) {
        StringBuilder builder = new StringBuilder("");
        for (String split : splits) {
            builder.append(split);
            builder.append("|");
        }
        String regex = builder.toString().trim();
        if (regex.endsWith("|")) {
            regex = regex.substring(0, regex.length() - 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Token Pattern: {}", (Object)regex);
        }
        if (expr != null && !expr.isEmpty()) {
            String expression = expr.replaceAll("  ", " ");
            expression = expression.trim();
            if (logger.isDebugEnabled()) {
                logger.debug("Parsing the expression : {}", (Object)expression);
            }
            ArrayList<String> tokenArray = new ArrayList<String>();
            Iterator<String> tokenizer = Arrays.asList(expression.split(regex)).iterator();
            block1: while (tokenizer.hasNext()) {
                String left;
                String token = tokenizer.next();
                if (token.equals("/*") || token.startsWith("/*")) {
                    while (tokenizer.hasNext() && !(token = tokenizer.next()).equals("*/") && !token.endsWith("*/")) {
                    }
                    continue;
                }
                if (!(ExpressionTokenizer.countOccurrences(token, '\'') != 2 || token.startsWith("'") && token.endsWith("'"))) {
                    if (!token.startsWith("'")) {
                        left = token.substring(0, token.indexOf("'"));
                        if (ExpressionTokenizer.validateToken(left = left.trim())) {
                            tokenArray.addAll(ExpressionTokenizer.parseToken(left));
                        } else if (left.isEmpty()) {
                            tokenArray.add(left);
                        }
                        token = token.substring(token.indexOf("'"), token.length());
                        token = token.trim();
                    }
                    if (!token.endsWith("'")) {
                        left = !token.startsWith("'") ? token.substring(0, token.indexOf("'") + 1) : token.substring(0, token.indexOf("'", 1) + 1);
                        if (ExpressionTokenizer.validateToken(left = left.trim())) {
                            tokenArray.addAll(ExpressionTokenizer.parseToken(left));
                        } else if (!left.isEmpty()) {
                            tokenArray.add(left);
                        }
                        String right = !token.startsWith("'") ? token.substring(token.indexOf("'") + 1, token.length()) : token.substring(token.indexOf("'", 1) + 1, token.length());
                        right = right.trim();
                        if (ExpressionTokenizer.validateToken(right)) {
                            tokenArray.addAll(ExpressionTokenizer.parseToken(right));
                            continue;
                        }
                        if (right.isEmpty()) continue;
                        tokenArray.add(right);
                        continue;
                    }
                    if (ExpressionTokenizer.validateToken(token)) {
                        tokenArray.addAll(ExpressionTokenizer.parseToken(token));
                        continue;
                    }
                    if (token.isEmpty()) continue;
                    tokenArray.add(token);
                    continue;
                }
                if (ExpressionTokenizer.countOccurrences(token, '\'') == 1 && !token.startsWith("'") && !token.endsWith("'")) {
                    left = token.substring(0, token.indexOf("'"));
                    if (ExpressionTokenizer.validateToken(left = left.trim())) {
                        tokenArray.addAll(ExpressionTokenizer.parseToken(left));
                    } else if (left.isEmpty()) {
                        tokenArray.add(left);
                    }
                    token = token.substring(token.indexOf("'"), token.length());
                    String tempToken = token.trim();
                    while (tokenizer.hasNext()) {
                        token = tokenizer.next();
                        if (!token.startsWith("'") && token.endsWith("'")) {
                            tempToken = tempToken + " " + token;
                            tokenArray.add(tempToken);
                            continue;
                        }
                        if (!token.startsWith("'") && token.contains("'")) {
                            left = token.substring(0, token.indexOf("'") + 1);
                            left = left.trim();
                            tempToken = tempToken + " " + left;
                            tokenArray.add(tempToken);
                            String right = token.substring(token.indexOf("'") + 1, token.length());
                            if (ExpressionTokenizer.validateToken(right)) {
                                tokenArray.addAll(ExpressionTokenizer.parseToken(right));
                                continue;
                            }
                            if (!right.isEmpty()) continue;
                            tokenArray.add(right);
                            continue;
                        }
                        tempToken = tempToken + " " + token;
                    }
                    continue;
                }
                if (ExpressionTokenizer.countOccurrences(token, '\'') == 1 && token.startsWith("'") && !token.endsWith("'")) {
                    StringBuilder tempToken = new StringBuilder(token);
                    while (tokenizer.hasNext()) {
                        token = tokenizer.next();
                        tempToken.append(" ").append(token);
                        if (token.startsWith("'") || !token.endsWith("'")) continue;
                        tokenArray.add(tempToken.toString());
                        continue block1;
                    }
                    continue;
                }
                if (ExpressionTokenizer.validateToken(token)) {
                    tokenArray.addAll(ExpressionTokenizer.parseToken(token));
                    continue;
                }
                if (token.isEmpty()) continue;
                tokenArray.add(token);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("tokens: {}", tokenArray);
            }
            return tokenArray.toArray(new String[tokenArray.size()]);
        }
        return null;
    }

    private static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    private static boolean validateToken(String token) {
        if (token.length() < 1) {
            return false;
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            return false;
        }
        if (token.contains("[")) {
            return true;
        }
        if (token.contains("]")) {
            return true;
        }
        if (token.contains("(")) {
            return true;
        }
        if (token.contains(")")) {
            return true;
        }
        if (token.contains("<>")) {
            return true;
        }
        if (token.contains("||")) {
            return true;
        }
        if (token.contains("&&")) {
            return true;
        }
        if (token.contains("=>")) {
            return true;
        }
        if (token.contains("!=")) {
            return true;
        }
        if (token.contains("<=")) {
            return true;
        }
        if (token.contains(">=")) {
            return true;
        }
        if (token.contains(":=")) {
            return true;
        }
        if (token.contains("=")) {
            return true;
        }
        if (token.contains(">")) {
            return true;
        }
        if (token.contains("<")) {
            return true;
        }
        if (token.contains("!")) {
            return true;
        }
        return token.contains(";");
    }

    private static List<String> parseToken(String token) {
        ArrayList<String> tokenArray = new ArrayList<String>();
        if (token.contains("(")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "("));
        } else if (token.contains(")")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, ")"));
        } else if (token.contains("[")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "["));
        } else if (token.contains("]")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "]"));
        } else if (token.contains("<>")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "<>"));
        } else if (token.contains("||")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "||"));
        } else if (token.contains("&&")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "&&"));
        } else if (token.contains("=>")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "=>"));
        } else if (token.contains("!=")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "!="));
        } else if (token.contains("<=")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "<="));
        } else if (token.contains(">=")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, ">="));
        } else if (token.contains(":=")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, ":="));
        } else if (token.contains("=")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "="));
        } else if (token.contains(">")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, ">"));
        } else if (token.contains("<")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "<"));
        } else if (token.contains("!")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "!"));
        } else if (token.contains("+")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, "+"));
        } else if (token.contains(";")) {
            tokenArray.addAll(ExpressionTokenizer.parse(token, ";"));
        } else {
            tokenArray.add(token);
        }
        return tokenArray;
    }

    private static List<String> parse(String token, String symbol) {
        ArrayList<String> tokenArray = new ArrayList<String>();
        while (token.contains(symbol)) {
            if (token.indexOf(symbol) == 0) {
                if (!symbol.isEmpty()) {
                    tokenArray.add(symbol);
                }
                token = token.substring(symbol.length(), token.length()).trim();
                continue;
            }
            String left = token.substring(0, token.indexOf(symbol)).trim();
            tokenArray.addAll(ExpressionTokenizer.parseToken(left));
            if (!symbol.isEmpty()) {
                tokenArray.add(symbol);
            }
            token = token.substring(token.indexOf(symbol) + symbol.length(), token.length()).trim();
        }
        if (!token.isEmpty()) {
            tokenArray.addAll(ExpressionTokenizer.parseToken(token));
        }
        return tokenArray;
    }

    public static String toString(String[] tokens, int pos) {
        return ExpressionTokenizer.toString(tokens, pos, 0);
    }

    public static String toString(String[] tokens, int pos, int startIndex) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (tokens.length >= pos + 1) {
            ++pos;
        }
        for (int i = startIndex; i < pos; ++i) {
            stringBuilder.append(tokens[i]);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public static String toString(String[] tokens) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (String token : tokens) {
            stringBuilder.append(token);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }
}

