/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.spring;

import org.dvare.config.RuleConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DvareConfigFactoryBean
implements FactoryBean<RuleConfiguration>,
ApplicationContextAware {
    private String[] functionPackages;
    private boolean silentMode = false;
    private ApplicationContext applicationContext;
    private AutowireCapableBeanFactory autowireCapableBeanFactory;

    public DvareConfigFactoryBean(String[] functionPackages, boolean silentMode) {
        this.functionPackages = functionPackages;
        this.silentMode = silentMode;
    }

    public DvareConfigFactoryBean(String[] functionBasePackages) {
        this.functionPackages = functionBasePackages;
    }

    public DvareConfigFactoryBean() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
    }

    public RuleConfiguration getObject() throws Exception {
        RuleConfiguration ruleConfiguration = new RuleConfiguration(this.functionPackages, this.silentMode);
        return ruleConfiguration;
    }

    public Class<RuleConfiguration> getObjectType() {
        return RuleConfiguration.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public String[] getFunctionPackages() {
        return this.functionPackages;
    }

    public void setFunctionPackages(String[] functionPackages) {
        this.functionPackages = functionPackages;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }
}

