/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.dvare.expression.datatype.BooleanType;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.datatype.DateTimeType;
import org.dvare.expression.datatype.DateType;
import org.dvare.expression.datatype.FloatType;
import org.dvare.expression.datatype.IntegerType;
import org.dvare.expression.datatype.RegexType;
import org.dvare.expression.datatype.StringType;

public class DataTypeMapping {
    public static Class<? extends DataTypeExpression> getDataTypeClass(String type) {
        return DataTypeMapping.getDataTypeClass(DataType.valueOf(type));
    }

    public static Class<? extends DataTypeExpression> getDataTypeClass(DataType type) {
        switch (type) {
            case BooleanType: 
            case BooleanListType: {
                return BooleanType.class;
            }
            case FloatType: 
            case FloatListType: {
                return FloatType.class;
            }
            case IntegerType: 
            case IntegerListType: {
                return IntegerType.class;
            }
            case StringType: 
            case StringListType: {
                return StringType.class;
            }
            case DateTimeType: 
            case DateTimeListType: {
                return DateTimeType.class;
            }
            case DateType: 
            case DateListType: {
                return DateType.class;
            }
            case RegexType: {
                return RegexType.class;
            }
        }
        return null;
    }

    public static DataType getTypeMapping(Class type) {
        return DataTypeMapping.getTypeMapping(type.getSimpleName());
    }

    public static DataType getTypeMapping(String type) {
        switch (type) {
            case "Boolean": {
                return DataType.BooleanType;
            }
            case "Boolean[]": {
                return DataType.BooleanListType;
            }
            case "boolean": {
                return DataType.BooleanType;
            }
            case "boolean[]": {
                return DataType.BooleanListType;
            }
            case "Integer": {
                return DataType.IntegerType;
            }
            case "Integer[]": {
                return DataType.IntegerListType;
            }
            case "int": {
                return DataType.IntegerType;
            }
            case "int[]": {
                return DataType.IntegerListType;
            }
            case "Float": {
                return DataType.FloatType;
            }
            case "Float[]": {
                return DataType.FloatListType;
            }
            case "float": {
                return DataType.FloatType;
            }
            case "float[]": {
                return DataType.FloatListType;
            }
            case "String": {
                return DataType.StringType;
            }
            case "String[]": {
                return DataType.StringListType;
            }
            case "Date": {
                return DataType.SimpleDateType;
            }
            case "Date[]": {
                return DataType.SimpleDateListType;
            }
            case "LocalDate": {
                return DataType.DateType;
            }
            case "LocalDate[]": {
                return DataType.DateListType;
            }
            case "LocalDateTime": {
                return DataType.DateTimeType;
            }
            case "LocalDateTime[]": {
                return DataType.DateTimeListType;
            }
        }
        return null;
    }

    public static Class getDataTypeMapping(String type) {
        return DataTypeMapping.getDataTypeMapping(DataType.valueOf(type));
    }

    public static Class getDataTypeMapping(DataType type) {
        switch (type) {
            case BooleanType: {
                return Boolean.class;
            }
            case BooleanListType: {
                return Boolean[].class;
            }
            case FloatType: {
                return Float.class;
            }
            case FloatListType: {
                return Float[].class;
            }
            case IntegerType: {
                return Integer.class;
            }
            case IntegerListType: {
                return Integer[].class;
            }
            case StringType: {
                return String.class;
            }
            case StringListType: {
                return String[].class;
            }
            case DateTimeType: {
                return LocalDateTime.class;
            }
            case DateTimeListType: {
                return LocalDateTime[].class;
            }
            case DateType: {
                return LocalDate.class;
            }
            case DateListType: {
                return LocalDate[].class;
            }
            case SimpleDateType: {
                return Date.class;
            }
            case SimpleDateListType: {
                return Date[].class;
            }
            case RegexType: {
                return String.class;
            }
        }
        return null;
    }
}

