/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.dvare.binding.model.TypeBinding;
import org.dvare.expression.datatype.DataType;
import org.dvare.parser.ExpressionParser;

public class TypeFinder {
    public static DataType findType(String name, TypeBinding typeBinding) {
        DataType variableType = null;
        if (name.contains(".")) {
            String[] fields = name.split("\\.");
            Iterator<String> iterator = Arrays.asList(fields).iterator();
            TypeBinding childType = typeBinding;
            while (iterator.hasNext()) {
                Object newType;
                String field = iterator.next();
                if (iterator.hasNext()) {
                    newType = childType.getDataType(field);
                    if (newType instanceof TypeBinding) {
                        childType = (TypeBinding)newType;
                        continue;
                    }
                    if (!(newType instanceof Class)) continue;
                    childType = ExpressionParser.translate((Class)newType);
                    continue;
                }
                newType = childType.getDataType(field);
                if (!(newType instanceof DataType)) continue;
                variableType = (DataType)((Object)newType);
            }
        } else {
            String field = name;
            Object newType = typeBinding.getDataType(field);
            if (newType instanceof DataType) {
                variableType = (DataType)((Object)newType);
            }
        }
        return variableType;
    }

    private static DataType findType(String name, Class type) {
        DataType variableType = null;
        if (name.contains(".")) {
            String[] fields = name.split(".");
            Iterator<String> iterator = Arrays.asList(fields).iterator();
            Class<?> childType = type;
            while (iterator.hasNext()) {
                Field newType;
                String field = iterator.next();
                if (iterator.hasNext()) {
                    newType = FieldUtils.getDeclaredField((Class)childType, (String)field, (boolean)true);
                    childType = newType.getType();
                    continue;
                }
                newType = FieldUtils.getDeclaredField((Class)childType, (String)field, (boolean)true);
                if (newType == null) continue;
                variableType = TypeFinder.typeMapping(newType.getType());
            }
        } else {
            String field = name;
            Field newType = FieldUtils.getDeclaredField((Class)type, (String)field, (boolean)true);
            if (newType != null) {
                variableType = TypeFinder.typeMapping(newType.getType());
            }
        }
        return variableType;
    }

    private static DataType typeMapping(Class type) {
        String simpleName = type.getSimpleName();
        if (simpleName.equals("int")) {
            return DataType.IntegerType;
        }
        simpleName = simpleName.substring(0, 1).toUpperCase() + simpleName.substring(1).toLowerCase();
        simpleName = simpleName + "Type";
        DataType dataType = DataType.valueOf(simpleName);
        return dataType;
    }
}

