/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Configures the annotated <i>bundle</i> class.
 *
 * <p>The <code>order</code> determines the invocation order of bundle. Lowest value means highest priority.</p>
 * <ul>
 *     <li>For both Business Logic and Security bundles bound to same service, invocation is performed due to
 *     <code>order</code> configured by this annotation during execution and authentication phases respectively.</li>
 *     <li>For Lifecycle bundles bound to same service, invocation is performed due to <code>order</code> configured
 *     by this annotation during service start. However, invocation is performed in reverse order during service
 *     stop.</li>
 * </ul>
 * @author Efe Kahraman
 * @since 1.0.0
 * @see Bundle
 */

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Config {

	/**
	 * Order of the bundle. Every bundle type has it's own order list.
	 * @return order
	 */
	long order();

	/**
	 * Starts bundle upon class loading.
	 * @return auto start flag
	 */
	boolean autostart() default true;

	
}
