/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that annotated method is the pre destructor of bundle.
 *
 * <p>A bundle class is allowed to have only one <code>&#64;Destroy</code> annotated method.</p>
 *
 * <p><code>&#64;Destroy</code> annotated method is called only when bundle is being stopped.</p>
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see Create
 */

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Destroy {

}
