/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that annotated class is a Lifecycle bundle. Lifecycle bundles are invoked only when service state
 * is changed.
 *
 * <p>A Lifecycle bundle registers itself to service state changes via <code>&#64;Signal</code> annotated methods.</p>
 *
 * <p><code>&#64;Lifecycle</code> can not be applied to <code>abstract</code> or <code>interface</code> types.
 * A Lifecycle bundle class must provide a <code>public</code> default constructor.</p>
 *
 * @author Efe Kahraman
 * @since  1.0.0
 * @see Bundle
 * @see org.dynamise.shared.bundle.annotation.Signal
 */

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Lifecycle {

	/**
	 * Name of the bundle. Name can include letters, numbers or underscore.
	 * @return bundle name
	 */
	String value();

	/**
	 * Version of the bundle.
	 * @return bundle version
	 */
	int version() default 0;

}