/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.annotation;

import java.lang.annotation.*;

/**
 * Defines the <i>service</i> which <i>bundle</i> is bound to. Mandatory for every <i>bundle</i> class.
 * <p>Can be used alone or in conjunction with one of the bundle annotations. If a class has only
 * <code>&#64;Service</code> annotation, it's called <i>anonymous bundle</i> and it's considered as a business logic
 * bundle. This kind of approach might be handy for getting quick results. I.e.:</p>
 * <pre>
 *     &#64;Service("foo")
 *     public class Bar {
 *         //...
 *     }
 * </pre>
 *
 * <p>A <i>service</i> has a unique name system wide. Any <i>bundle</i> declared with a particular service name
 * is treated as a part of that service instance.</p>
 *
 * <p>Services may be started and stopped by Dynamise server.</p>
 *
 * <p>Builtin logging infrastructure is provided for services. It's recommended to use provided logger instead of
 * any other logging utilities. See {@link org.dynamise.shared.service.ServiceLogger ServiceLogger}
 * for further details.</p>
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see Bundle
 */

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Service {

	/**
	 * Name of the service. Name can include letters, numbers or underscore.
	 * @return service name
	 */
	String value();

}
