/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.bundle;

/**
 * General exception class for bundles. If it's thrown by an <code>&#64;Invoke</code> or <code>&#64;Authenticate</code>
 * annotated method, service execution stops immediately.
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see org.dynamise.shared.bundle.annotation.Invoke
 * @see org.dynamise.shared.bundle.annotation.Authenticate
 */
@SuppressWarnings("serial")
public class BundleException extends RuntimeException {

	/**
	 * @see RuntimeException#RuntimeException()
	 */
	public BundleException() { }

	/**
	 * @param message message
	 * @see RuntimeException#RuntimeException(String)
	 */
	public BundleException(String message) {
		super(message);
	}


	/**
	 * @param cause cause
	 * @see RuntimeException#RuntimeException(Throwable)
	 */
	public BundleException(Throwable cause) {
		super(cause);
	}

	/**
	 * @param message message
	 * @param cause cause
	 * @see RuntimeException#RuntimeException(String, Throwable)
	 */
	public BundleException(String message, Throwable cause) {
		super(message, cause);
	}


}
