/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.bundle;

/**
 * Builtin properties infrastructure for bundles. A bundle can access it's own property file by using this class.
 * Property files should reside under Dynamise Server's configuration path. Property file name for a specific bundle is
 * constructed as below:
 * <p><code>{service}-{type}-{name}-{version}.properties</code></p>
 *
 * <p><code>{type}</code> is the abbreviation of bundle type. Possible values are:</p>
 * <table cellpadding="3" summary="Bundle Types">
 *     <tr><th>Abbr.</th><th>Type</th></tr>
 *     <tr><td><code>bl</code></td><td>Business Logic</td></tr>
 *     <tr><td><code>se</code></td><td>Security</td></tr>
 *     <tr><td><code>lf</code></td><td>Lifecycle</td></tr>
 * </table>
 *
 * <p>Can not be declared as <code>static</code> in bundle class.</p>
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see org.dynamise.shared.annotation.Bundle
 */
public interface BundleProperties {

	/**
	 * Gets the property value as <code>String</code>.
	 * @param key property key
	 * @return String value or <code>null</code> if property does not exist
	 */
	String getString(String key);

	/**
	 * Gets the property value as <code>Boolean</code>.
	 * @param key property key
	 * @return Boolean value or <code>null</code> if property does not exist
	 */
	Boolean getBoolean(String key);

	/**
	 * Gets the property value as <code>Long</code>.
	 * @param key property key
	 * @return Long value or <code>null</code> if property does not exist
	 */
	Long getLong(String key);

	/**
	 * Gets the property value as <code>Double</code>.
	 * @param key property key
	 * @return Double value or <code>null</code> if property does not exist
	 */
	Double getDouble(String key);

}
