/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.bundle.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that annotated method is an entry point for service authentication. Security bundles may have one
 * or more <code>&#64;Authenticate</code> annotated methods to control user access for specific service.
 *
 * <p>If a method is annotated with <code>&#64;Authenticate</code> may take following parameters in method
 * signature:</p>
 * <ul>
 *     <li>{@link org.dynamise.shared.context.ServiceContext Service context}</li>
 *     <li>{@link org.dynamise.shared.context.SecurityContext Security context}</li>
 * </ul>
 *
 * <p>If <code>&#64;Authenticate</code> annotated method throws {@link org.dynamise.shared.bundle.BundleException
 * BundleException}, request will be refused with authentication error.</p>
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see org.dynamise.shared.annotation.Security
 */

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Authenticate {

}
