/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.bundle.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.dynamise.shared.bundle.LifecycleEvent;

/**
 * Indicates that annotated method is registered to service state change event. Lifecycle bundles may have one
 * <code>&#64;Signal</code> annotated methods per event.
 *
 * <p>If a method is annotated with <code>&#64;Signal</code> may take following parameters in method
 * signature:</p>
 * <ul>
 *     <li>{@link org.dynamise.shared.context.ServiceContext Service context}</li>
 * </ul>
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see org.dynamise.shared.annotation.Lifecycle
 * @see LifecycleEvent
 */

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Signal {

	/**
	 * Event to be registered.
	 * @return event
	 */
	LifecycleEvent value();
}
