/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.context;

/**
 * Context object holding data about authentication of service request.
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see org.dynamise.shared.bundle.annotation.Authenticate
 * @see org.dynamise.shared.bundle.annotation.Invoke
 */
public interface SecurityContext {

    /**
     * Principle value passed by client.
     * @return principle
     */
    String getPrinciple();

    /**
     * Credential value passed by client.
     * @return credential
     */
    String getCredential();

    /**
     * Client's source IP address.
     * @return IP address
     */
    String getRemoteIpAddr();
    
}
