/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.context;

/**
 * Provides a mapping for object transfer among service bundles.
 *
 * @author Efe Kahraman
 * @since 1.0.0
 * @see org.dynamise.shared.bundle.annotation.Signal
 * @see org.dynamise.shared.bundle.annotation.Invoke
 * @see org.dynamise.shared.bundle.annotation.Authenticate
 */
public interface ServiceContext {

	/**
	 * Gets data from map.
	 * @param key key
	 * @return stored object
	 */
	Object lookup(String key);

	/**
	 * Puts data to map.
	 * @param key key
	 * @param value object
	 */
	void put(String key, Object value);

}
