/*******************************************************************************
 * Copyright 2015 Efe Kahraman
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package org.dynamise.shared.service;

/**
 * Builtin logging infrastructure for services. A bundle can write to service's log by using this class. Service logs
 * are written to <code>service.log</code> file which resides under Dynamise Server's log path.
 *
 * <p>Can not be declared as <code>static</code> in bundle class.</p>
 *
 * @author Efe Kahraman
 * @since 1.0.0
 */
public interface ServiceLogger {

	/**
	 * Prints verbose log messages.
	 * @param log message
	 */
	void verbose(String log);

	/**
	 * Prints debug log messages.
	 * @param log message
	 */
	void debug(String log);

	/**
	 * Prints info log messages.
	 * @param log message
	 */
	void info(String log);

	/**
	 * Prints warn log messages.
	 * @param log message
	 */
	void warn(String log);

	/**
	 * Prints error log messages.
	 * @param log message
	 * @param t cause
	 */
	void error(String log, Throwable t);

}
