/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.envers.dao.impl;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.dao.Pageable;
import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.dao.SortOrders;
import com.ocs.dynamo.dao.impl.BaseDaoImpl;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.envers.dao.VersionedEntityDao;
import com.ocs.dynamo.envers.domain.DynamoRevisionEntity;
import com.ocs.dynamo.envers.domain.RevisionKey;
import com.ocs.dynamo.envers.domain.RevisionType;
import com.ocs.dynamo.envers.domain.VersionedEntity;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.filter.And;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Contains;
import com.ocs.dynamo.filter.DynamoFilterUtil;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.In;
import com.ocs.dynamo.filter.Like;
import com.ocs.dynamo.filter.Not;
import com.ocs.dynamo.filter.Or;
import com.ocs.dynamo.utils.DateUtils;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditConjunction;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.AuditDisjunction;
import org.hibernate.envers.query.criteria.AuditProperty;
import org.springframework.transaction.annotation.Transactional;

public abstract class VersionedEntityDaoImpl<ID, T extends AbstractEntity<ID>, U extends VersionedEntity<ID, T>>
extends BaseDaoImpl<RevisionKey<ID>, U>
implements VersionedEntityDao<ID, T, U> {
    private static final String ENTITY_STRING = "entity.";
    private static final Map<String, String> REVISION_PROPS = new ConcurrentHashMap<String, String>();

    private void addAdditionalFilters(AuditQuery aq, Filter filter) {
        AuditCriterion ac = this.createAuditCriterion(filter);
        if (ac != null) {
            aq.add(ac);
        }
    }

    private void addIdFilter(AuditQuery aq, Filter filter) {
        Filter idFilter;
        if (filter != null && (idFilter = DynamoFilterUtil.extractFilter((Filter)filter, (String)"id")) != null) {
            Compare.Equal comp = (Compare.Equal)idFilter;
            Object id = comp.getValue();
            aq.add(AuditEntity.id().eq(id));
        }
    }

    @Transactional
    public long count(Filter filter, boolean distinct) {
        AuditQuery aq = this.getAuditReader().createQuery().forRevisionsOfEntity(this.getBaseEntityClass(), false, true);
        this.addIdFilter(aq, filter);
        this.addAdditionalFilters(aq, filter);
        return aq.getResultList().size();
    }

    private AuditCriterion createAuditCriterion(Filter filter) {
        if (filter instanceof Compare.Equal) {
            Compare.Equal eq = (Compare.Equal)filter;
            return this.createAuditProperty(eq.getPropertyId()).eq(eq.getValue());
        }
        if (filter instanceof Like) {
            Like like = (Like)filter;
            return this.createAuditProperty(like.getPropertyId()).like((Object)like.getValue());
        }
        if (filter instanceof Compare.Greater) {
            Compare.Greater gt = (Compare.Greater)filter;
            return this.createAuditProperty(gt.getPropertyId()).gt(gt.getValue());
        }
        if (filter instanceof Compare.GreaterOrEqual) {
            Compare.GreaterOrEqual ge = (Compare.GreaterOrEqual)filter;
            return this.createAuditProperty(ge.getPropertyId()).ge(ge.getValue());
        }
        if (filter instanceof Compare.Less) {
            Compare.Less lt = (Compare.Less)filter;
            return this.createAuditProperty(lt.getPropertyId()).lt(lt.getValue());
        }
        if (filter instanceof Compare.LessOrEqual) {
            Compare.LessOrEqual le = (Compare.LessOrEqual)filter;
            return this.createAuditProperty(le.getPropertyId()).le(le.getValue());
        }
        if (filter instanceof And) {
            And and = (And)filter;
            AuditConjunction ac = AuditEntity.conjunction();
            for (Filter f : and.getFilters()) {
                AuditCriterion ct = this.createAuditCriterion(f);
                if (ct == null) continue;
                ac.add(ct);
            }
            return ac;
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            AuditDisjunction ad = AuditEntity.disjunction();
            for (Filter f : or.getFilters()) {
                AuditCriterion ct = this.createAuditCriterion(f);
                if (ct == null) continue;
                ad.add(ct);
            }
            return ad;
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            AuditCriterion ct = this.createAuditCriterion(not.getFilter());
            if (ct != null) {
                return AuditEntity.not((AuditCriterion)ct);
            }
        } else {
            if (filter instanceof In) {
                In in = (In)filter;
                return AuditEntity.property((String)in.getPropertyId()).in(in.getValues());
            }
            if (filter instanceof Contains) {
                Contains c = (Contains)filter;
                throw new OCSRuntimeException("Contains filter is not supported for property " + c.getPropertyId());
            }
        }
        return null;
    }

    private <X> AuditProperty<X> createAuditProperty(String prop) {
        if ("revisionType".equals(prop)) {
            return AuditEntity.revisionType();
        }
        if (REVISION_PROPS.containsKey(prop)) {
            prop = REVISION_PROPS.get(prop);
            return AuditEntity.revisionProperty((String)prop);
        }
        int index = prop.indexOf(ENTITY_STRING);
        if (index >= 0) {
            prop = prop.substring(index + ENTITY_STRING.length());
        }
        return AuditEntity.property((String)prop);
    }

    protected abstract U createVersionedEntity(T var1, int var2);

    protected void doMap(U u) {
    }

    @Transactional
    public List<U> fetch(Filter filter, FetchJoinInformation ... joins) {
        return this.fetch(filter, (Pageable)null, joins);
    }

    @Transactional
    public List<U> fetch(Filter filter, Pageable pageable, FetchJoinInformation ... joins) {
        AuditQuery aq = this.getAuditReader().createQuery().forRevisionsOfEntity(this.getBaseEntityClass(), false, true);
        this.addIdFilter(aq, filter);
        this.addAdditionalFilters(aq, filter);
        if (pageable != null) {
            aq.setFirstResult(pageable.getOffset());
            aq.setMaxResults(pageable.getPageSize());
            if (pageable.getSortOrders() != null) {
                for (SortOrder so : pageable.getSortOrders().toArray()) {
                    String prop = so.getProperty();
                    AuditProperty ap = this.createAuditProperty(prop);
                    if (so.isAscending()) {
                        aq.addOrder(ap.asc());
                        continue;
                    }
                    aq.addOrder(ap.desc());
                }
            }
        }
        ArrayList<U> resultList = new ArrayList<U>();
        List revs = aq.getResultList();
        for (Object[] rev : revs) {
            U u = this.map(rev);
            resultList.add(u);
        }
        return resultList;
    }

    @Transactional
    public U fetchById(RevisionKey<ID> id, FetchJoinInformation ... joins) {
        try {
            AuditQuery aq = this.getAuditReader().createQuery().forRevisionsOfEntity(this.getBaseEntityClass(), false, true);
            aq.add(AuditEntity.id().eq(id.getId()));
            aq.add(AuditEntity.revisionNumber().eq((Object)id.getRevision()));
            Object[] rev = (Object[])aq.getSingleResult();
            return this.map(rev);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<U> fetchByIds(List<RevisionKey<ID>> ids, SortOrders sortOrders, FetchJoinInformation ... joins) {
        throw new UnsupportedOperationException();
    }

    public List<RevisionKey<ID>> findIds(Filter filter, SortOrder ... sortOrders) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number findRevisionNumber(LocalDateTime ldt) {
        return this.getAuditReader().getRevisionNumberForDate(DateUtils.toLegacyDate((LocalDateTime)ldt));
    }

    @Override
    @Transactional
    public List<U> findRevisions(ID id) {
        List revs = this.getAuditReader().createQuery().forRevisionsOfEntity(this.getBaseEntityClass(), false, true).add(AuditEntity.id().eq(id)).getResultList();
        ArrayList<U> resultList = new ArrayList<U>();
        for (Object[] rev : revs) {
            resultList.add(this.map(rev));
        }
        return resultList;
    }

    private AuditReader getAuditReader() {
        return AuditReaderFactory.get((EntityManager)this.getEntityManager());
    }

    public abstract Class<T> getBaseEntityClass();

    protected EntityPathBase<U> getDslRoot() {
        throw new UnsupportedOperationException();
    }

    @PostConstruct
    public void init() {
        REVISION_PROPS.put("revision", "id");
        REVISION_PROPS.put("revisionTimeStamp", "timestamp");
        REVISION_PROPS.put("user", "username");
    }

    private U map(Object[] rev) {
        if (rev == null) {
            return null;
        }
        AbstractEntity t = (AbstractEntity)rev[0];
        DynamoRevisionEntity revisionData = (DynamoRevisionEntity)((Object)rev[1]);
        U u = this.createVersionedEntity(t, revisionData.getId());
        Instant i = Instant.ofEpochMilli(revisionData.getTimestamp());
        ((VersionedEntity)((Object)u)).setRevisionTimeStamp(ZonedDateTime.ofInstant(i, ZoneId.systemDefault()));
        ((VersionedEntity)((Object)u)).setUser(revisionData.getUsername());
        ((VersionedEntity)((Object)u)).setRevisionType(RevisionType.fromInternal((org.hibernate.envers.RevisionType)rev[2]));
        if (((VersionedEntity)((Object)u)).getEntity() != null) {
            this.doMap(u);
        }
        return u;
    }
}

