/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.envers.domain;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.annotation.Attribute;
import com.ocs.dynamo.envers.domain.RevisionKey;
import com.ocs.dynamo.envers.domain.RevisionType;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class VersionedEntity<ID, T extends AbstractEntity<ID>>
extends AbstractEntity<RevisionKey<ID>> {
    private static final long serialVersionUID = 4784364096429184957L;
    @Attribute(sortable=true, displayName="Revision number")
    private int revision;
    @Attribute(sortable=false)
    private T entity;
    @Attribute(sortable=true)
    private ZonedDateTime revisionTimeStamp;
    @Attribute(sortable=true)
    private String user;
    private RevisionKey<ID> id;
    @Attribute(sortable=true)
    private RevisionType revisionType;

    public VersionedEntity(T entity, int revision) {
        this.entity = entity;
        this.revision = revision;
        this.id = new RevisionKey<Object>(entity.getId(), revision);
    }

    public T getEntity() {
        return this.entity;
    }

    public RevisionKey<ID> getId() {
        return this.id;
    }

    public int getRevision() {
        return this.revision;
    }

    public ZonedDateTime getRevisionTimeStamp() {
        return this.revisionTimeStamp;
    }

    public String getUser() {
        return this.user;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public void setId(RevisionKey<ID> id) {
        this.id = id;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setRevisionTimeStamp(ZonedDateTime revisionTimeStamp) {
        this.revisionTimeStamp = revisionTimeStamp;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public RevisionType getRevisionType() {
        return this.revisionType;
    }

    public void setRevisionType(RevisionType revisionType) {
        this.revisionType = revisionType;
    }
}

