/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.domain.model.impl;

import com.google.common.collect.Lists;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeDateType;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeSelectMode;
import com.ocs.dynamo.domain.model.AttributeTextFieldMode;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.CheckboxMode;
import com.ocs.dynamo.domain.model.EditableType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.FieldFactory;
import com.ocs.dynamo.domain.model.NumberSelectMode;
import com.ocs.dynamo.domain.model.impl.FieldFactoryContextImpl;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocator;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.component.EntityComboBox;
import com.ocs.dynamo.ui.component.EntityLookupField;
import com.ocs.dynamo.ui.component.FancyListSelect;
import com.ocs.dynamo.ui.component.QuickAddEntityComboBox;
import com.ocs.dynamo.ui.component.QuickAddListSelect;
import com.ocs.dynamo.ui.component.SimpleTokenFieldSelect;
import com.ocs.dynamo.ui.component.TimeField;
import com.ocs.dynamo.ui.component.TokenFieldSelect;
import com.ocs.dynamo.ui.component.URLField;
import com.ocs.dynamo.ui.composite.form.CollectionTable;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.converter.BigDecimalToDoubleConverter;
import com.ocs.dynamo.ui.converter.ConverterFactory;
import com.ocs.dynamo.ui.converter.IntToDoubleConverter;
import com.ocs.dynamo.ui.converter.LocalDateWeekCodeConverter;
import com.ocs.dynamo.ui.converter.LongToDoubleConverter;
import com.ocs.dynamo.ui.converter.WeekCodeConverter;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.ui.validator.URLValidator;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.utils.DateUtils;
import com.ocs.dynamo.utils.NumberUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.DefaultFieldGroupFieldFactory;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.validator.BeanValidator;
import com.vaadin.data.validator.EmailValidator;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.DateField;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.Slider;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.vaadin.teemu.switchui.Switch;

public class ModelBasedFieldFactory<T>
extends DefaultFieldGroupFieldFactory
implements TableFieldFactory {
    private static ConcurrentMap<String, ModelBasedFieldFactory<?>> nonValidatingInstances = new ConcurrentHashMap();
    private static ConcurrentMap<String, ModelBasedFieldFactory<?>> searchInstances = new ConcurrentHashMap();
    private static final long serialVersionUID = -5684112523268959448L;
    private static ConcurrentMap<String, ModelBasedFieldFactory<?>> validatingInstances = new ConcurrentHashMap();
    private MessageService messageService;
    private EntityModel<T> model;
    private ServiceLocator serviceLocator = ServiceLocatorFactory.getServiceLocator();
    private Collection<FieldFactory> fieldFactories;
    private boolean search;
    private boolean validate;

    public ModelBasedFieldFactory(EntityModel<T> model, MessageService messageService, boolean validate, boolean search) {
        this.model = model;
        this.messageService = messageService;
        this.validate = validate;
        this.search = search;
        this.fieldFactories = this.serviceLocator.getServices(FieldFactory.class);
    }

    public static <T> ModelBasedFieldFactory<T> getInstance(EntityModel<T> model, MessageService messageService) {
        if (!nonValidatingInstances.containsKey(model.getReference())) {
            nonValidatingInstances.put(model.getReference(), new ModelBasedFieldFactory<T>(model, messageService, false, false));
        }
        return (ModelBasedFieldFactory)((Object)nonValidatingInstances.get(model.getReference()));
    }

    public static <T> ModelBasedFieldFactory<T> getSearchInstance(EntityModel<T> model, MessageService messageService) {
        if (!searchInstances.containsKey(model.getReference())) {
            searchInstances.put(model.getReference(), new ModelBasedFieldFactory<T>(model, messageService, false, true));
        }
        return (ModelBasedFieldFactory)((Object)searchInstances.get(model.getReference()));
    }

    public static <T> ModelBasedFieldFactory<T> getValidatingInstance(EntityModel<T> model, MessageService messageService) {
        if (!validatingInstances.containsKey(model.getReference())) {
            validatingInstances.put(model.getReference(), new ModelBasedFieldFactory<T>(model, messageService, true, false));
        }
        return (ModelBasedFieldFactory)((Object)validatingInstances.get(model.getReference()));
    }

    public <ID extends Serializable, S extends AbstractEntity<ID>> AbstractField<?> constructComboBox(EntityModel<?> entityModel, AttributeModel attributeModel, Container.Filter filter, boolean search) {
        entityModel = this.resolveEntityModel(entityModel, attributeModel);
        BaseService service = this.serviceLocator.getServiceForEntity(entityModel.getEntityClass());
        SortOrder[] sos = this.constructSortOrder(entityModel);
        return new QuickAddEntityComboBox(entityModel, attributeModel, service, EntityComboBox.SelectMode.FILTERED, filter, search, null, sos);
    }

    public Field<?> constructField(AttributeModel attributeModel, Map<String, Container.Filter> fieldFilters, EntityModel<?> fieldEntityModel) {
        Object field = null;
        if (this.fieldFactories != null && !this.fieldFactories.isEmpty()) {
            FieldFactoryContextImpl c;
            FieldFactory ff;
            Iterator<FieldFactory> iterator = this.fieldFactories.iterator();
            while (iterator.hasNext() && (field = (ff = iterator.next()).constructField(c = new FieldFactoryContextImpl().setAttributeModel(attributeModel).setFieldFilters(fieldFilters).setFieldEntityModel(fieldEntityModel))) == null) {
            }
        }
        if (field == null) {
            Container.Filter fieldFilter;
            Container.Filter filter = fieldFilter = fieldFilters == null ? null : fieldFilters.get(attributeModel.getPath());
            field = fieldFilter != null ? (AttributeType.MASTER.equals((Object)attributeModel.getAttributeType()) ? this.constructSelectField(attributeModel, fieldEntityModel, fieldFilter) : (this.search && AttributeSelectMode.TOKEN.equals((Object)attributeModel.getSearchSelectMode()) && AttributeType.BASIC.equals((Object)attributeModel.getAttributeType()) ? this.constructSimpleTokenField(fieldEntityModel != null ? fieldEntityModel : attributeModel.getEntityModel(), attributeModel, attributeModel.getPath().substring(attributeModel.getPath().lastIndexOf(46) + 1), false, fieldFilter) : this.constructCollectionSelect(fieldEntityModel, attributeModel, fieldFilter, true, this.search))) : this.createField(attributeModel.getPath(), fieldEntityModel);
        }
        field.setRequired(this.search ? attributeModel.isRequiredForSearching() : attributeModel.isRequired());
        if (field instanceof AbstractComponent) {
            ((AbstractComponent)field).setImmediate(true);
            field.setCaption(attributeModel.getDisplayName());
        }
        return field;
    }

    public <ID extends Serializable, S extends AbstractEntity<ID>> Field<?> constructCollectionSelect(EntityModel<?> fieldEntityModel, AttributeModel attributeModel, Container.Filter fieldFilter, boolean multipleSelect, boolean search) {
        AttributeSelectMode mode;
        EntityModel<?> em = this.resolveEntityModel(fieldEntityModel, attributeModel);
        BaseService service = this.serviceLocator.getServiceForEntity(em.getEntityClass());
        SortOrder[] sos = this.constructSortOrder(em);
        AttributeSelectMode attributeSelectMode = mode = search ? attributeModel.getSearchSelectMode() : attributeModel.getSelectMode();
        if (AttributeSelectMode.LOOKUP.equals((Object)mode)) {
            return this.constructLookupField(fieldEntityModel, attributeModel, fieldFilter, search, true);
        }
        if (AttributeSelectMode.FANCY_LIST.equals((Object)mode)) {
            FancyListSelect listSelect = new FancyListSelect(service, em, attributeModel, fieldFilter, search, sos);
            listSelect.setRows(SystemPropertyUtils.getDefaultListSelectRows());
            return listSelect;
        }
        if (AttributeSelectMode.LIST.equals((Object)mode)) {
            return new QuickAddListSelect(em, attributeModel, service, fieldFilter, multipleSelect, SystemPropertyUtils.getDefaultListSelectRows(), sos);
        }
        return new TokenFieldSelect(em, attributeModel, service, fieldFilter, search, sos);
    }

    public <ID extends Serializable, S extends AbstractEntity<ID>> EntityLookupField<ID, S> constructLookupField(EntityModel<?> overruled, AttributeModel attributeModel, Container.Filter fieldFilter, boolean search, boolean multiSelect) {
        EntityModel entityModel = overruled != null ? overruled : this.serviceLocator.getEntityModelFactory().getModel(attributeModel.getNormalizedType());
        BaseService service = this.serviceLocator.getServiceForEntity(attributeModel.getMemberType() != null ? attributeModel.getMemberType() : entityModel.getEntityClass());
        Object[] sos = this.constructSortOrder(entityModel);
        return new EntityLookupField(service, entityModel, attributeModel, fieldFilter, search, multiSelect, sos.length == 0 ? null : Lists.newArrayList((Object[])sos), new FetchJoinInformation[0]);
    }

    public ComboBox constructSearchBooleanComboBox(AttributeModel am) {
        ComboBox cb = new ComboBox();
        cb.addItem((Object)Boolean.TRUE);
        cb.setItemCaption((Object)Boolean.TRUE, am.getTrueRepresentation());
        cb.addItem((Object)Boolean.FALSE);
        cb.setItemCaption((Object)Boolean.FALSE, am.getFalseRepresentation());
        return cb;
    }

    public static ComboBox constructStringListCombo(List<String> values, AttributeModel am) {
        ComboBox cb = new ComboBox();
        cb.setCaption(am.getDisplayName());
        cb.addItems(values);
        cb.setFilteringMode(FilteringMode.CONTAINS);
        return cb;
    }

    private <ID extends Serializable, S extends AbstractEntity<ID>, O extends Comparable<O>> SimpleTokenFieldSelect<ID, S, O> constructSimpleTokenField(EntityModel<?> entityModel, AttributeModel attributeModel, String distinctField, boolean elementCollection, Container.Filter fieldFilter) {
        BaseService service = this.serviceLocator.getServiceForEntity(entityModel.getEntityClass());
        SortOrder[] sos = distinctField == null ? this.constructSortOrder(entityModel) : new SortOrder[]{new SortOrder((Object)distinctField, SortDirection.ASCENDING)};
        return new SimpleTokenFieldSelect(service, entityModel, attributeModel, fieldFilter, distinctField, attributeModel.getNormalizedType(), elementCollection, sos);
    }

    private SortOrder[] constructSortOrder(EntityModel<?> entityModel) {
        SortOrder[] sos = new SortOrder[entityModel.getSortOrder().size()];
        int i = 0;
        for (AttributeModel am : entityModel.getSortOrder().keySet()) {
            sos[i++] = new SortOrder((Object)am.getName(), (Boolean)entityModel.getSortOrder().get(am) != false ? SortDirection.ASCENDING : SortDirection.DESCENDING);
        }
        return sos;
    }

    public <E extends Field<?>> E createEnumCombo(Class<?> type, Class<E> fieldType) {
        AbstractSelect s = this.createCompatibleSelect(fieldType);
        s.setNullSelectionAllowed(true);
        this.fillEnumField(s, type);
        return (E)s;
    }

    public <F extends Field> F createField(Class<?> type, Class<F> fieldType) {
        if (Enum.class.isAssignableFrom(type)) {
            if (AbstractSelect.class.isAssignableFrom(fieldType)) {
                return this.createEnumCombo(type, fieldType);
            }
            ComboBox cb = this.createEnumCombo(type, ComboBox.class);
            cb.setFilteringMode(FilteringMode.CONTAINS);
            return (F)cb;
        }
        if (AbstractEntity.class.isAssignableFrom(type)) {
            EntityModel entityModel = this.serviceLocator.getEntityModelFactory().getModel(type);
            return (F)this.constructComboBox(entityModel, null, null, this.search);
        }
        return (F)super.createField(type, fieldType);
    }

    public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
        return this.createField(propertyId.toString(), null);
    }

    public Field<?> createField(String propertyId) {
        return this.createField(propertyId, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Field<?> createField(String propertyId, EntityModel<?> fieldEntityModel) {
        void var4_21;
        DateField df;
        Object tf;
        AttributeModel attributeModel = this.model.getAttributeModel(propertyId);
        if (EditableType.READ_ONLY.equals((Object)attributeModel.getEditableType()) && !attributeModel.isUrl() && !AttributeType.DETAIL.equals((Object)attributeModel.getAttributeType()) && !this.search) {
            return null;
        }
        Object var4_4 = null;
        if (AttributeTextFieldMode.TEXTAREA.equals((Object)attributeModel.getTextFieldMode()) && !this.search) {
            TextArea textArea = new TextArea();
        } else if ((NumberUtils.isLong((Class)attributeModel.getType()) || NumberUtils.isInteger((Class)attributeModel.getType()) || BigDecimal.class.equals((Object)attributeModel.getType())) && NumberSelectMode.SLIDER.equals((Object)attributeModel.getNumberSelectMode())) {
            Slider slider = new Slider(attributeModel.getDisplayName());
            if (NumberUtils.isInteger((Class)attributeModel.getType())) {
                slider.setConverter((Converter)new IntToDoubleConverter());
            } else if (NumberUtils.isLong((Class)attributeModel.getType())) {
                slider.setConverter((Converter)new LongToDoubleConverter());
            } else {
                slider.setConverter((Converter)new BigDecimalToDoubleConverter());
                slider.setResolution(attributeModel.getPrecision());
            }
            if (attributeModel.getMinValue() != null) {
                slider.setMin((double)attributeModel.getMinValue().longValue());
            }
            if (attributeModel.getMaxValue() != null) {
                slider.setMax((double)attributeModel.getMaxValue().longValue());
            }
            Slider slider2 = slider;
        } else if (attributeModel.isWeek()) {
            tf = new TextField();
            tf.setConverter((Converter)(Date.class.equals((Object)attributeModel.getType()) ? new WeekCodeConverter() : new LocalDateWeekCodeConverter()));
            TextField textField = tf;
        } else if (this.search && AttributeSelectMode.TOKEN.equals((Object)attributeModel.getSearchSelectMode()) && AttributeType.BASIC.equals((Object)attributeModel.getAttributeType())) {
            SimpleTokenFieldSelect simpleTokenFieldSelect = this.constructSimpleTokenField(fieldEntityModel != null ? fieldEntityModel : attributeModel.getEntityModel(), attributeModel, propertyId.substring(propertyId.lastIndexOf(46) + 1), false, null);
        } else if (this.search && (attributeModel.getType().equals(Boolean.class) || attributeModel.getType().equals(Boolean.TYPE))) {
            ComboBox comboBox = this.constructSearchBooleanComboBox(attributeModel);
        } else if (AbstractEntity.class.isAssignableFrom(attributeModel.getType())) {
            Field<?> field = this.constructSelectField(attributeModel, fieldEntityModel, null);
        } else if (AttributeType.ELEMENT_COLLECTION.equals((Object)attributeModel.getAttributeType())) {
            if (!this.search) {
                FormOptions fo = new FormOptions().setShowRemoveButton(true);
                if (!String.class.equals((Object)attributeModel.getMemberType()) && !Integer.class.equals((Object)attributeModel.getMemberType()) && !Long.class.equals((Object)attributeModel.getMemberType()) && !BigDecimal.class.equals((Object)attributeModel.getMemberType())) throw new OCSRuntimeException("Element collections of this type are currently not supported");
                CollectionTable collectionTable = new CollectionTable(attributeModel, true, fo);
            } else {
                SimpleTokenFieldSelect simpleTokenFieldSelect = this.constructSimpleTokenField(fieldEntityModel != null ? fieldEntityModel : attributeModel.getEntityModel(), attributeModel, propertyId.substring(propertyId.lastIndexOf(46) + 1), true, null);
            }
        } else if (Collection.class.isAssignableFrom(attributeModel.getType())) {
            Field<?> field = this.constructCollectionSelect(fieldEntityModel, attributeModel, null, true, this.search);
        } else if (LocalDate.class.equals((Object)attributeModel.getType())) {
            df = new DateField();
            df.setResolution(Resolution.DAY);
            df.setConverter((Converter)ConverterFactory.createLocalDateConverter());
            df.setTimeZone(VaadinUtils.getTimeZone(UI.getCurrent()));
            DateField dateField = df;
        } else if (LocalDateTime.class.equals((Object)attributeModel.getType())) {
            df = new DateField();
            df.setResolution(Resolution.SECOND);
            df.setConverter((Converter)ConverterFactory.createLocalDateTimeConverter());
            df.setTimeZone(VaadinUtils.getTimeZone(UI.getCurrent()));
            DateField dateField = df;
        } else if (ZonedDateTime.class.equals((Object)attributeModel.getType())) {
            df = new DateField();
            df.setResolution(Resolution.SECOND);
            df.setConverter((Converter)ConverterFactory.createZonedDateTimeConverter());
            df.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
            DateField dateField = df;
        } else if (AttributeDateType.TIME.equals((Object)attributeModel.getDateType())) {
            tf = new TimeField();
            ((TimeField)((Object)tf)).setResolution(Resolution.MINUTE);
            ((TimeField)((Object)tf)).setLocale(VaadinUtils.getLocale());
            if (DateUtils.isJava8DateType((Class)attributeModel.getType())) {
                tf.setConverter((Converter)ConverterFactory.createLocalTimeConverter());
            }
            Object object = tf;
        } else if (attributeModel.isUrl()) {
            tf = (TextField)this.createField(attributeModel.getType(), Field.class);
            tf.addValidator((Validator)new URLValidator(this.messageService.getMessage("ocs.no.valid.url", VaadinUtils.getLocale())));
            tf.setNullRepresentation(null);
            tf.setSizeFull();
            URLField uRLField = new URLField((TextField)tf, attributeModel, false);
            uRLField.setSizeFull();
        } else if (Boolean.class.equals((Object)attributeModel.getType()) && CheckboxMode.SWITCH.equals((Object)attributeModel.getCheckboxMode())) {
            Switch switch_ = new Switch();
            switch_.addStyleName("compact");
        } else {
            Field field = this.createField(attributeModel.getType(), Field.class);
        }
        if (var4_21 instanceof DateField) {
            df = (DateField)var4_21;
            Locale dateLocale = VaadinUtils.getDateLocale();
            df.setLocale(dateLocale);
            if (UI.getCurrent() != null) {
                df.setTimeZone(VaadinUtils.getTimeZone(UI.getCurrent()));
            }
        }
        var4_21.setCaption(attributeModel.getDisplayName());
        this.postProcessField((Field<?>)var4_21, attributeModel);
        if (!this.validate) return var4_21;
        var4_21.addValidator((Validator)new BeanValidator(this.model.getEntityClass(), propertyId));
        if (!attributeModel.isUrl()) {
            var4_21.setEnabled(!EditableType.READ_ONLY.equals((Object)attributeModel.getEditableType()));
        }
        if (!attributeModel.isNumerical()) return var4_21;
        var4_21.addStyleName("numerical");
        return var4_21;
    }

    private void postProcessField(Field<?> field, AttributeModel attributeModel) {
        if (field instanceof AbstractTextField) {
            AbstractTextField textField = (AbstractTextField)field;
            textField.setDescription(attributeModel.getDescription());
            textField.setNullSettingAllowed(true);
            textField.setNullRepresentation("");
            if (!StringUtils.isEmpty((String)attributeModel.getPrompt())) {
                textField.setInputPrompt(attributeModel.getPrompt());
            }
            this.setConverters(textField, attributeModel);
            if (attributeModel.isEmail()) {
                field.addValidator((Validator)new EmailValidator(this.messageService.getMessage("ocs.no.valid.email", VaadinUtils.getLocale())));
            }
        } else if (field instanceof DateField) {
            DateField dateField = (DateField)field;
            if (attributeModel.getDisplayFormat() != null) {
                dateField.setDateFormat(attributeModel.getDisplayFormat());
            }
            if (AttributeDateType.TIMESTAMP.equals((Object)attributeModel.getDateType())) {
                dateField.setResolution(Resolution.SECOND);
            }
        }
    }

    protected Field<?> constructSelectField(AttributeModel attributeModel, EntityModel<?> fieldEntityModel, Container.Filter fieldFilter) {
        AttributeSelectMode selectMode;
        Object field = null;
        AttributeSelectMode attributeSelectMode = selectMode = this.search ? attributeModel.getSearchSelectMode() : attributeModel.getSelectMode();
        field = this.search && attributeModel.isMultipleSearch() ? this.constructCollectionSelect(fieldEntityModel, attributeModel, fieldFilter, true, this.search) : (AttributeSelectMode.COMBO.equals((Object)selectMode) ? this.constructComboBox(fieldEntityModel, attributeModel, fieldFilter, this.search) : (AttributeSelectMode.LOOKUP.equals((Object)selectMode) ? this.constructLookupField(fieldEntityModel, attributeModel, fieldFilter, this.search, false) : this.constructCollectionSelect(fieldEntityModel, attributeModel, fieldFilter, false, this.search)));
        return field;
    }

    private <E extends Enum<E>> void fillEnumField(AbstractSelect select, Class<E> enumClass) {
        select.removeAllItems();
        for (Object p : select.getContainerPropertyIds()) {
            select.removeContainerProperty(p);
        }
        select.addContainerProperty(CAPTION_PROPERTY_ID, String.class, (Object)"");
        select.setItemCaptionPropertyId(CAPTION_PROPERTY_ID);
        List<Enum> list = Arrays.asList(enumClass.getEnumConstants());
        list.sort((a, b) -> {
            String msg1 = this.messageService.getEnumMessage(enumClass, a, VaadinUtils.getLocale());
            String msg2 = this.messageService.getEnumMessage(enumClass, b, VaadinUtils.getLocale());
            return msg1.compareToIgnoreCase(msg2);
        });
        for (Enum e : list) {
            Item newItem = select.addItem((Object)e);
            String msg = this.messageService.getEnumMessage(enumClass, e, VaadinUtils.getLocale());
            if (msg != null) {
                newItem.getItemProperty(CAPTION_PROPERTY_ID).setValue((Object)msg);
                continue;
            }
            newItem.getItemProperty(CAPTION_PROPERTY_ID).setValue((Object)DefaultFieldFactory.createCaptionByPropertyId((Object)e.name()));
        }
    }

    public EntityModel<T> getModel() {
        return this.model;
    }

    private EntityModel<?> resolveEntityModel(EntityModel<?> entityModel, AttributeModel attributeModel) {
        if (entityModel == null) {
            if (attributeModel.getNestedEntityModel() != null) {
                entityModel = attributeModel.getNestedEntityModel();
            } else {
                Class type = attributeModel.getNormalizedType();
                entityModel = this.serviceLocator.getEntityModelFactory().getModel(type.asSubclass(AbstractEntity.class));
            }
        }
        return entityModel;
    }

    protected void setConverters(AbstractTextField textField, AttributeModel am) {
        if (am.getType().equals(BigDecimal.class)) {
            textField.setConverter((Converter)ConverterFactory.createBigDecimalConverter(am.isCurrency(), am.isPercentage(), SystemPropertyUtils.useThousandsGroupingInEditMode(), am.getPrecision(), VaadinUtils.getCurrencySymbol()));
        } else if (NumberUtils.isInteger((Class)am.getType())) {
            textField.setConverter((Converter)ConverterFactory.createIntegerConverter(SystemPropertyUtils.useThousandsGroupingInEditMode(), am.isPercentage()));
        } else if (NumberUtils.isLong((Class)am.getType())) {
            textField.setConverter((Converter)ConverterFactory.createLongConverter(SystemPropertyUtils.useThousandsGroupingInEditMode(), am.isPercentage()));
        }
    }
}

