/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.filter;

import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.filter.And;
import com.ocs.dynamo.filter.Between;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.FilterUtil;
import com.ocs.dynamo.filter.IsNull;
import com.ocs.dynamo.filter.Like;
import com.ocs.dynamo.filter.Not;
import com.ocs.dynamo.filter.Or;
import com.vaadin.data.Container;
import com.vaadin.data.util.filter.Compare;
import com.vaadin.data.util.filter.SimpleStringFilter;
import org.springframework.core.convert.converter.Converter;

public class FilterConverter
implements Converter<Container.Filter, Filter> {
    private EntityModel<?> entityModel;

    public FilterConverter(EntityModel<?> entityModel) {
        this.entityModel = entityModel;
    }

    public Filter convert(Container.Filter filter) {
        if (filter == null) {
            return null;
        }
        And result = null;
        if (filter instanceof com.vaadin.data.util.filter.And) {
            And and;
            result = and = new And(new Filter[0]);
            for (Container.Filter f : ((com.vaadin.data.util.filter.And)filter).getFilters()) {
                Filter converted = this.convert(f);
                if (converted == null) continue;
                and.getFilters().add(converted);
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Or) {
            Or or = new Or(new Filter[0]);
            result = or;
            for (Container.Filter f : ((com.vaadin.data.util.filter.Or)filter).getFilters()) {
                or.getFilters().add(this.convert(f));
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Not) {
            com.vaadin.data.util.filter.Not not = (com.vaadin.data.util.filter.Not)filter;
            result = new Not(this.convert(not.getFilter()));
        } else if (filter instanceof com.vaadin.data.util.filter.Between) {
            com.vaadin.data.util.filter.Between between = (com.vaadin.data.util.filter.Between)filter;
            result = new Between(between.getPropertyId().toString(), between.getStartValue(), between.getEndValue());
        } else if (filter instanceof Compare) {
            Compare compare = (Compare)filter;
            switch (compare.getOperation()) {
                case EQUAL: {
                    result = new Compare.Equal(compare.getPropertyId().toString(), compare.getValue());
                    break;
                }
                case GREATER: {
                    result = new Compare.Greater(compare.getPropertyId().toString(), compare.getValue());
                    break;
                }
                case GREATER_OR_EQUAL: {
                    result = new Compare.GreaterOrEqual(compare.getPropertyId().toString(), compare.getValue());
                    break;
                }
                case LESS: {
                    result = new Compare.Less(compare.getPropertyId().toString(), compare.getValue());
                    break;
                }
                case LESS_OR_EQUAL: {
                    result = new Compare.LessOrEqual(compare.getPropertyId().toString(), compare.getValue());
                    break;
                }
                default: {
                    result = null;
                    break;
                }
            }
        } else if (filter instanceof com.vaadin.data.util.filter.IsNull) {
            com.vaadin.data.util.filter.IsNull isNull = (com.vaadin.data.util.filter.IsNull)filter;
            result = new IsNull(isNull.getPropertyId().toString());
        } else if (filter instanceof com.vaadin.data.util.filter.Like) {
            com.vaadin.data.util.filter.Like like = (com.vaadin.data.util.filter.Like)filter;
            result = new Like(like.getPropertyId().toString(), like.getValue(), like.isCaseSensitive());
        } else if (filter instanceof SimpleStringFilter) {
            SimpleStringFilter like = (SimpleStringFilter)filter;
            result = new Like(like.getPropertyId().toString(), (like.isOnlyMatchPrefix() ? "" : "%") + like.getFilterString() + "%", !like.isIgnoreCase());
        } else {
            throw new UnsupportedOperationException("Filter: " + filter.getClass().getName() + " is not supported.");
        }
        if (this.entityModel != null) {
            FilterUtil.replaceMasterAndDetailFilters((Filter)result, this.entityModel);
        }
        return result;
    }
}

