/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.filter;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.filter.AbstractJunctionFilter;
import com.ocs.dynamo.filter.And;
import com.ocs.dynamo.filter.Between;
import com.ocs.dynamo.filter.Compare;
import com.ocs.dynamo.filter.Contains;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.In;
import com.ocs.dynamo.filter.Like;
import com.ocs.dynamo.filter.Not;
import com.ocs.dynamo.filter.Or;
import com.ocs.dynamo.filter.PropertyFilter;
import com.vaadin.data.Container;
import com.vaadin.data.util.filter.Compare;
import com.vaadin.data.util.filter.SimpleStringFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.util.StringUtils;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static Filter extractFilter(Filter filter, String propertyId) {
        if (filter instanceof AbstractJunctionFilter) {
            AbstractJunctionFilter junction = (AbstractJunctionFilter)filter;
            for (Filter child : junction.getFilters()) {
                Filter found = FilterUtil.extractFilter(child, propertyId);
                if (found == null) continue;
                return found;
            }
        } else if (filter instanceof Compare) {
            Compare compare = (Compare)filter;
            if (compare.getPropertyId().equals(propertyId)) {
                return compare;
            }
        } else if (filter instanceof Like) {
            Like like = (Like)filter;
            if (like.getPropertyId().equals(propertyId)) {
                return like;
            }
        } else if (filter instanceof In) {
            In in = (In)filter;
            if (in.getPropertyId().equals(propertyId)) {
                return in;
            }
        } else if (filter instanceof Contains) {
            Contains c = (Contains)filter;
            if (c.getPropertyId().equals(propertyId)) {
                return c;
            }
        } else if (filter instanceof Between) {
            Between between = (Between)filter;
            if (between.getPropertyId().equals(propertyId)) {
                return between;
            }
        } else if (filter instanceof Not) {
            Not not = (Not)filter;
            return FilterUtil.extractFilter(not.getFilter(), propertyId);
        }
        return null;
    }

    public static Container.Filter extractFilter(Container.Filter filter, String propertyId, Class<? extends Container.Filter>[] typesToFind) {
        com.vaadin.data.util.filter.Between between;
        List<Class<? extends Container.Filter>> types;
        List<Class<? extends Container.Filter>> list = types = typesToFind == null || typesToFind.length == 0 || typesToFind.length == 1 && typesToFind[0] == null ? null : Arrays.asList(typesToFind);
        if (filter instanceof com.vaadin.data.util.filter.AbstractJunctionFilter) {
            com.vaadin.data.util.filter.AbstractJunctionFilter junction = (com.vaadin.data.util.filter.AbstractJunctionFilter)filter;
            for (Container.Filter child : junction.getFilters()) {
                Container.Filter found = FilterUtil.extractFilter(child, propertyId, typesToFind);
                if (found == null) continue;
                return found;
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Compare && (types == null || types.contains(filter.getClass()))) {
            com.vaadin.data.util.filter.Compare compare = (com.vaadin.data.util.filter.Compare)filter;
            if (compare.getPropertyId().equals(propertyId)) {
                return compare;
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Like && (types == null || types.contains(filter.getClass()))) {
            com.vaadin.data.util.filter.Like like = (com.vaadin.data.util.filter.Like)filter;
            if (like.getPropertyId().equals(propertyId)) {
                return like;
            }
        } else if (filter instanceof SimpleStringFilter && (types == null || types.contains(filter.getClass()))) {
            SimpleStringFilter ssf = (SimpleStringFilter)filter;
            if (ssf.getPropertyId().equals(propertyId)) {
                return ssf;
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Between && (types == null || types.contains(filter.getClass())) && (between = (com.vaadin.data.util.filter.Between)filter).getPropertyId().equals(propertyId)) {
            return between;
        }
        return null;
    }

    @SafeVarargs
    public static Object extractFilterValue(Container.Filter filter, String propertyId, Class<? extends Container.Filter> ... typesToFind) {
        com.vaadin.data.util.filter.Between ssf;
        List<Class<? extends Container.Filter>> types;
        List<Class<? extends Container.Filter>> list = types = typesToFind == null || typesToFind.length == 1 && typesToFind[0] == null ? null : Arrays.asList(typesToFind);
        if (filter instanceof com.vaadin.data.util.filter.AbstractJunctionFilter) {
            com.vaadin.data.util.filter.AbstractJunctionFilter junction = (com.vaadin.data.util.filter.AbstractJunctionFilter)filter;
            for (Container.Filter child : junction.getFilters()) {
                Object value;
                Container.Filter found = FilterUtil.extractFilter(child, propertyId, typesToFind);
                if (found == null || (value = FilterUtil.extractFilterValue(found, propertyId, typesToFind)) == null) continue;
                return value;
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Compare && (types == null || types.contains(filter.getClass()))) {
            com.vaadin.data.util.filter.Compare compare = (com.vaadin.data.util.filter.Compare)filter;
            if (compare.getPropertyId().equals(propertyId)) {
                return compare.getValue();
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Like && (types == null || types.contains(filter.getClass()))) {
            com.vaadin.data.util.filter.Like like = (com.vaadin.data.util.filter.Like)filter;
            if (like.getPropertyId().equals(propertyId)) {
                return like.getValue();
            }
        } else if (filter instanceof SimpleStringFilter && (types == null || types.contains(filter.getClass()))) {
            SimpleStringFilter ssf2 = (SimpleStringFilter)filter;
            if (ssf2.getPropertyId().equals(propertyId)) {
                return ssf2.getFilterString();
            }
        } else if (filter instanceof com.vaadin.data.util.filter.Between && (types == null || types.contains(filter.getClass())) && (ssf = (com.vaadin.data.util.filter.Between)filter).getPropertyId().equals(propertyId)) {
            return ssf.getStartValue();
        }
        return null;
    }

    public static List<Filter> flattenAnd(And and) {
        ArrayList<Filter> children = new ArrayList<Filter>();
        for (Filter f : and.getFilters()) {
            if (f instanceof And) {
                And childAnd = (And)f;
                List<Filter> temp = FilterUtil.flattenAnd(childAnd);
                children.addAll(temp);
                continue;
            }
            children.add(f);
        }
        return children;
    }

    public static boolean isTrue(Container.Filter filter, String propertyId) {
        Container.Filter extracted = FilterUtil.extractFilter(filter, propertyId, null);
        if (extracted != null && extracted instanceof Compare.Equal) {
            Compare.Equal equal = (Compare.Equal)extracted;
            return Boolean.TRUE.equals(equal.getValue());
        }
        return false;
    }

    public static boolean isFilterValueSet(Container.Filter filter, Set<String> ignore) {
        boolean result = false;
        if (filter instanceof com.vaadin.data.util.filter.AbstractJunctionFilter) {
            com.vaadin.data.util.filter.AbstractJunctionFilter jf = (com.vaadin.data.util.filter.AbstractJunctionFilter)filter;
            for (Container.Filter f : jf.getFilters()) {
                result |= FilterUtil.isFilterValueSet(f, ignore);
            }
        } else {
            if (filter instanceof com.vaadin.data.util.filter.Compare) {
                com.vaadin.data.util.filter.Compare eq = (com.vaadin.data.util.filter.Compare)filter;
                if (ignore.contains(eq.getPropertyId())) {
                    return false;
                }
                return eq.getValue() != null;
            }
            if (filter instanceof SimpleStringFilter) {
                SimpleStringFilter sf = (SimpleStringFilter)filter;
                if (ignore.contains(sf.getPropertyId())) {
                    return false;
                }
                return !StringUtils.isEmpty((Object)sf.getFilterString());
            }
            if (filter instanceof com.vaadin.data.util.filter.Like) {
                com.vaadin.data.util.filter.Like lf = (com.vaadin.data.util.filter.Like)filter;
                if (ignore.contains(lf.getPropertyId())) {
                    return false;
                }
                return !StringUtils.isEmpty((Object)lf.getValue());
            }
            if (filter instanceof com.vaadin.data.util.filter.Between) {
                com.vaadin.data.util.filter.Between bt = (com.vaadin.data.util.filter.Between)filter;
                if (ignore.contains(bt.getPropertyId())) {
                    return false;
                }
                return bt.getStartValue() != null || bt.getEndValue() != null;
            }
        }
        return result;
    }

    public static void removeFilters(Filter filter, String ... propertyIds) {
        if (filter instanceof AbstractJunctionFilter) {
            Filter child2;
            AbstractJunctionFilter junction = (AbstractJunctionFilter)filter;
            Iterator it = junction.getFilters().iterator();
            while (it.hasNext()) {
                child2 = (Filter)it.next();
                if (!(child2 instanceof PropertyFilter)) continue;
                PropertyFilter pf = (PropertyFilter)child2;
                for (String s : propertyIds) {
                    if (!pf.getPropertyId().equals(s)) continue;
                    it.remove();
                }
            }
            for (Filter child2 : junction.getFilters()) {
                if (child2 instanceof PropertyFilter) continue;
                FilterUtil.removeFilters(child2, propertyIds);
            }
            it = junction.getFilters().iterator();
            while (it.hasNext()) {
                Not not;
                child2 = (Filter)it.next();
                if (child2 instanceof AbstractJunctionFilter) {
                    AbstractJunctionFilter ajf = (AbstractJunctionFilter)child2;
                    if (!ajf.getFilters().isEmpty()) continue;
                    it.remove();
                    continue;
                }
                if (!(child2 instanceof Not) || (not = (Not)child2).getFilter() != null) continue;
                it.remove();
            }
        } else if (filter instanceof Not) {
            AbstractJunctionFilter ajf;
            Filter child;
            Not not = (Not)filter;
            if (not.getFilter() != null) {
                FilterUtil.removeFilters(not.getFilter(), propertyIds);
            }
            if ((child = not.getFilter()) instanceof PropertyFilter) {
                PropertyFilter pf = (PropertyFilter)child;
                for (String s : propertyIds) {
                    if (!pf.getPropertyId().equals(s)) continue;
                    not.setFilter(null);
                }
            } else if (child instanceof AbstractJunctionFilter && (ajf = (AbstractJunctionFilter)child).getFilters().isEmpty()) {
                not.setFilter(null);
            }
        }
    }

    private static void replaceFilter(Filter parent, Filter original, Filter newFilter, String propertyId, boolean firstOnly) {
        if (original instanceof AbstractJunctionFilter) {
            AbstractJunctionFilter junction = (AbstractJunctionFilter)original;
            for (Filter child : junction.getFilters()) {
                FilterUtil.replaceFilter((Filter)junction, child, newFilter, propertyId, firstOnly);
            }
        } else if (original instanceof PropertyFilter) {
            PropertyFilter pf = (PropertyFilter)original;
            if (pf.getPropertyId().equals(propertyId)) {
                if (parent instanceof AbstractJunctionFilter) {
                    AbstractJunctionFilter pj = (AbstractJunctionFilter)parent;
                    pj.replace(original, newFilter, firstOnly);
                } else if (parent instanceof Not) {
                    Not not = (Not)parent;
                    not.setFilter(newFilter);
                }
                if (firstOnly) {
                    throw new OCSRuntimeException();
                }
            }
        } else if (original instanceof Not) {
            Not not = (Not)original;
            FilterUtil.replaceFilter((Filter)not, not.getFilter(), newFilter, propertyId, firstOnly);
        }
    }

    public static void replaceFilter(Filter original, Filter newFilter, String propertyId, boolean firstOnly) {
        try {
            FilterUtil.replaceFilter(null, original, newFilter, propertyId, firstOnly);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void replaceMasterAndDetailFilters(Filter filter, EntityModel<?> entityModel) {
        for (AttributeModel am : entityModel.getAttributeModels()) {
            FilterUtil.replaceMasterDetailFilter(filter, am);
            if (am.getNestedEntityModel() == null) continue;
            FilterUtil.replaceMasterAndDetailFilters(filter, am.getNestedEntityModel());
        }
    }

    private static void replaceMasterDetailFilter(Filter filter, AttributeModel am) {
        Filter detailFilter;
        if ((AttributeType.DETAIL.equals((Object)am.getAttributeType()) || AttributeType.ELEMENT_COLLECTION.equals((Object)am.getAttributeType()) || (AttributeType.MASTER.equals((Object)am.getAttributeType()) || AttributeType.BASIC.equals((Object)am.getAttributeType())) && am.isMultipleSearch()) && (detailFilter = FilterUtil.extractFilter(filter, am.getPath())) != null && detailFilter instanceof Compare.Equal) {
            String prop = am.getReplacementSearchPath() != null ? am.getReplacementSearchPath() : am.getPath();
            Compare.Equal bf = (Compare.Equal)detailFilter;
            if (AttributeType.DETAIL.equals((Object)am.getAttributeType()) || AttributeType.ELEMENT_COLLECTION.equals((Object)am.getAttributeType())) {
                if (bf.getValue() instanceof Collection) {
                    Collection col = (Collection)bf.getValue();
                    Or or = new Or(new Filter[0]);
                    for (Object o : col) {
                        or.or(new Filter[]{new Contains(prop, o)});
                    }
                    FilterUtil.replaceFilter(filter, (Filter)or, am.getPath(), false);
                } else {
                    FilterUtil.replaceFilter(filter, (Filter)new Contains(prop, bf.getValue()), am.getPath(), false);
                }
            } else if (bf.getValue() instanceof Collection) {
                Collection col = (Collection)bf.getValue();
                In in = new In(prop, col);
                FilterUtil.replaceFilter(null, filter, (Filter)in, am.getPath(), false);
            }
        }
    }
}

