/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.service.impl;

import com.ocs.dynamo.service.UserDetailsService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DefaultUserDetailsServiceImpl
implements UserDetailsService {
    private static final String SYSTEM = "system";

    public String getCurrentUserName() {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            return request.getUserPrincipal().getName();
        }
        catch (Exception ex) {
            return SYSTEM;
        }
    }

    public boolean isUserInRole(String role) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            return request.isUserInRole(role);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isUserInRole(String ... roles) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            for (String r : roles) {
                if (!request.isUserInRole(r)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

