/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui;

import com.ocs.dynamo.ui.menu.MenuService;
import com.ocs.dynamo.ui.navigator.CustomNavigator;
import com.vaadin.annotations.Widgetset;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Notification;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;

@Widgetset(value="com.ocs.dynamo.DynamoWidgetSet")
public abstract class BaseUI
extends UI {
    private static final long serialVersionUID = 5903140845804805314L;
    private Integer selectedTab;
    private String screenMode;
    private CustomNavigator navigator;
    private Map<Class<?>, Consumer<?>> entityOnViewMapping = new HashMap();
    @Autowired
    private MenuService menuService;
    private MenuBar menuBar;

    public Integer getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(Integer selectedTab) {
        this.selectedTab = selectedTab;
    }

    public String getScreenMode() {
        return this.screenMode;
    }

    public void setScreenMode(String screenMode) {
        this.screenMode = screenMode;
    }

    protected void initNavigation(ViewProvider viewProvider, SingleComponentContainer container, String startView, boolean alwaysReload) {
        this.navigator = new CustomNavigator((UI)this, (ViewDisplay)new Navigator.SingleComponentContainerViewDisplay(container));
        this.navigator.setAlwaysReload(alwaysReload);
        UI.getCurrent().setNavigator((Navigator)this.navigator);
        this.navigator.addProvider(viewProvider);
        this.navigator.navigateTo(startView);
    }

    public CustomNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(CustomNavigator navigator) {
        this.navigator = navigator;
    }

    public void addEntityOnViewMapping(Class<?> entityClass, Consumer<?> navigateAction) {
        this.entityOnViewMapping.put(entityClass, navigateAction);
    }

    public void navigateToEntityScreenDirectly(Object o) {
        Consumer<Object> navigateToView = this.entityOnViewMapping.getOrDefault(o.getClass(), err -> Notification.show((String)("No view mapping registered for class: " + o.getClass()), (Notification.Type)Notification.Type.ERROR_MESSAGE));
        if (navigateToView != null) {
            try {
                navigateToView.accept(o);
            }
            catch (Exception e) {
                Notification.show((String)("An exception occurred while executing the mapped action for class: " + o.getClass() + " with message: " + e.getMessage()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                throw e;
            }
        }
    }

    public void navigate(String viewName) {
        this.navigator.navigateTo(viewName);
        if (this.menuBar != null) {
            this.menuService.setLastVisited(this.menuBar, viewName);
        }
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
    }
}

