/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.auth.impl;

import com.ocs.dynamo.service.UserDetailsService;
import com.ocs.dynamo.ui.auth.Authorized;
import com.ocs.dynamo.ui.auth.PermissionChecker;
import com.vaadin.spring.annotation.SpringView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class DefaultPermissionCheckerImpl
implements PermissionChecker {
    private static final Logger LOG = Logger.getLogger(DefaultPermissionCheckerImpl.class);
    @Inject
    private UserDetailsService userDetailsService;
    private Map<String, List<String>> permissions = new HashMap<String, List<String>>();
    private Map<String, Boolean> editOnly = new HashMap<String, Boolean>();
    private String basePackage;

    public DefaultPermissionCheckerImpl(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public List<String> getViewNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.permissions.keySet()));
    }

    @Override
    public boolean isAccessAllowed(String viewName) {
        List<String> roles = this.permissions.get(viewName);
        if (roles == null) {
            return true;
        }
        for (String s : roles) {
            if (!this.userDetailsService.isUserInRole(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEditOnly(String viewName) {
        if (!this.editOnly.containsKey(viewName)) {
            return false;
        }
        return this.editOnly.get(viewName);
    }

    @PostConstruct
    public void postConstruct() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SpringView.class));
        Set views = provider.findCandidateComponents(this.basePackage);
        for (BeanDefinition d : views) {
            try {
                Class<?> clazz = Class.forName(d.getBeanClassName());
                SpringView view = clazz.getAnnotation(SpringView.class);
                Authorized auth = clazz.getAnnotation(Authorized.class);
                if (auth == null || auth.roles().length <= 0) continue;
                int p = d.getBeanClassName().lastIndexOf(46);
                this.permissions.put(d.getBeanClassName().substring(p + 1), Arrays.asList(auth.roles()));
                this.editOnly.put(d.getBeanClassName().substring(p + 1), auth.editOnly());
                this.permissions.put(view.name(), Arrays.asList(auth.roles()));
                this.editOnly.put(view.name(), auth.editOnly());
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

