/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.exception.OCSNonUniqueException;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.ui.composite.dialog.SimpleModalDialog;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.utils.ClassUtils;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import org.springframework.util.StringUtils;

public abstract class AddNewValueDialog<ID extends Serializable, T extends AbstractEntity<ID>>
extends SimpleModalDialog {
    private static final long serialVersionUID = 6208738706327329145L;
    private final MessageService messageService;
    private TextField valueField;
    private BaseService<ID, T> service;
    private EntityModel<T> entityModel;
    private AttributeModel attributeModel;

    public AddNewValueDialog(EntityModel<T> entityModel, AttributeModel attributeModel, BaseService<ID, T> service, MessageService messageService) {
        super(true);
        this.entityModel = entityModel;
        this.attributeModel = attributeModel;
        this.service = service;
        this.messageService = messageService;
    }

    protected abstract void afterNewEntityAdded(T var1);

    @Override
    protected void doBuild(Layout parent) {
        this.valueField = new TextField(this.messageService.getMessage("ocs.enter.new.value", VaadinUtils.getLocale()));
        this.valueField.setSizeFull();
        this.valueField.focus();
        parent.addComponent((Component)this.valueField);
    }

    @Override
    protected boolean doClose() {
        String value = (String)this.valueField.getValue();
        if (!StringUtils.isEmpty((Object)value)) {
            AbstractEntity t = this.service.createNewEntity();
            String propName = this.attributeModel.getQuickAddPropertyName();
            Integer maxLength = this.entityModel.getAttributeModel(propName).getMaxLength();
            if (maxLength != null && value.length() > maxLength) {
                this.showNotification(this.messageService.getMessage("ocs.value.too.long", VaadinUtils.getLocale()), Notification.Type.ERROR_MESSAGE);
                return false;
            }
            ClassUtils.setFieldValue((Object)t, (String)propName, (Object)value);
            try {
                t = this.service.save(t);
                this.afterNewEntityAdded(t);
                return true;
            }
            catch (OCSNonUniqueException ex) {
                this.showNotification(ex.getMessage(), Notification.Type.ERROR_MESSAGE);
            }
        } else {
            this.showNotification(this.messageService.getMessage("ocs.value.required", VaadinUtils.getLocale()), Notification.Type.ERROR_MESSAGE);
        }
        return false;
    }

    public TextField getValueField() {
        return this.valueField;
    }

    @Override
    protected String getTitle() {
        return this.messageService.getMessage("ocs.enter.new.value", VaadinUtils.getLocale());
    }
}

