/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.FontIcon;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;

public class CollapsiblePanel
extends VerticalLayout {
    private static final long serialVersionUID = -7979238391035057707L;
    private FontIcon closedIcon = FontAwesome.PLUS_CIRCLE;
    private FontIcon openIcon = FontAwesome.MINUS_CIRCLE;
    private Button toggle = new Button((Resource)this.openIcon);
    private VerticalLayout contentWrapper = new VerticalLayout();

    public CollapsiblePanel() {
        this.toggle.setStyleName("borderless leftAlign");
        this.toggle.setSizeFull();
        this.contentWrapper.setVisible(true);
        this.addComponents(new Component[]{this.toggle, this.contentWrapper});
        this.toggle.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5662067017197269837L;

            public void buttonClick(Button.ClickEvent event) {
                CollapsiblePanel.this.setOpen(!CollapsiblePanel.this.isOpen());
            }
        });
    }

    public CollapsiblePanel(String caption, Component content) {
        this();
        this.setCaption(caption);
        this.contentWrapper.addComponent(content);
    }

    public boolean isOpen() {
        return this.toggle.getIcon() == this.openIcon;
    }

    public CollapsiblePanel setOpen(boolean open) {
        this.contentWrapper.setVisible(open);
        this.toggle.setIcon((Resource)(open ? this.getOpenIcon() : this.getClosedIcon()));
        return this;
    }

    public CollapsiblePanel setContent(Component content) {
        this.contentWrapper.removeAllComponents();
        this.contentWrapper.addComponent(content);
        return this;
    }

    public void setCaption(String caption) {
        this.toggle.setCaption(caption);
    }

    public VerticalLayout getContentWrapper() {
        return this.contentWrapper;
    }

    public FontIcon getClosedIcon() {
        return this.closedIcon;
    }

    public void setClosedIcon(FontIcon closedIcon) {
        this.closedIcon = closedIcon;
    }

    public FontIcon getOpenIcon() {
        return this.openIcon;
    }

    public void setOpenIcon(FontIcon openIcon) {
        this.openIcon = openIcon;
    }
}

