/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.filter.FilterConverter;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.ServiceLocator;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.Cascadable;
import com.ocs.dynamo.ui.component.IgnoreDiacriticsStringFilter;
import com.ocs.dynamo.ui.utils.SortUtil;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.filter.And;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.ComboBox;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EntityComboBox<ID extends Serializable, T extends AbstractEntity<ID>>
extends ComboBox
implements Refreshable,
Cascadable {
    private static final long serialVersionUID = 3041574615271340579L;
    private BaseService<ID, T> service;
    private AttributeModel attributeModel;
    private SelectMode selectMode = SelectMode.FILTERED;
    private final SortOrder[] sortOrder;
    private Container.Filter filter;
    private Container.Filter originalFilter;
    private Container.Filter additionalFilter;
    private ServiceLocator serviceLocator = ServiceLocatorFactory.getServiceLocator();

    public EntityComboBox(EntityModel<T> targetEntityModel, AttributeModel attributeModel, BaseService<ID, T> service, Container.Filter filter, SortOrder ... sortOrder) {
        this(targetEntityModel, attributeModel, service, SelectMode.FILTERED, filter, null, sortOrder);
    }

    public EntityComboBox(EntityModel<T> targetEntityModel, AttributeModel attributeModel, BaseService<ID, T> service, SelectMode mode, Container.Filter filter, List<T> items, SortOrder ... sortOrder) {
        this.service = service;
        this.selectMode = mode;
        this.sortOrder = sortOrder;
        this.attributeModel = attributeModel;
        this.filter = filter;
        if (attributeModel != null) {
            this.setCaption(attributeModel.getDisplayName());
        }
        this.setRequiredError(this.serviceLocator.getMessageService().getMessage("ocs.may.not.be.null", VaadinUtils.getLocale()));
        this.setFilteringMode(FilteringMode.CONTAINS);
        BeanItemContainer container = new BeanItemContainer(targetEntityModel.getEntityClass());
        this.setContainerDataSource((Container)container);
        if (SelectMode.ALL.equals((Object)mode)) {
            if (sortOrder != null) {
                container.addAll((Collection)service.findAll(SortUtil.translate(sortOrder)));
            }
        } else if (SelectMode.FILTERED.equals((Object)mode)) {
            items = service.find(new FilterConverter(null).convert(filter), SortUtil.translate(sortOrder));
            container.addAll((Collection)items);
        } else if (SelectMode.FIXED.equals((Object)mode)) {
            container.addAll(items);
        }
        this.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.setItemCaptionPropertyId(targetEntityModel.getDisplayProperty());
        this.setSizeFull();
    }

    public EntityComboBox(EntityModel<T> targetEntityModel, AttributeModel attributeModel, BaseService<ID, T> service, SortOrder ... sortOrder) {
        this(targetEntityModel, attributeModel, service, SelectMode.ALL, null, null, sortOrder);
    }

    public EntityComboBox(EntityModel<T> targetEntityModel, AttributeModel attributeModel, List<T> items) {
        this(targetEntityModel, attributeModel, null, SelectMode.FIXED, null, items, new SortOrder[0]);
    }

    public void addEntity(T entity) {
        BeanItemContainer bic = (BeanItemContainer)this.getContainerDataSource();
        bic.addBean(entity);
    }

    protected Container.Filter buildFilter(String filterString, FilteringMode filteringMode) {
        IgnoreDiacriticsStringFilter ft = null;
        if (!StringUtils.isEmpty((String)filterString)) {
            switch (filteringMode) {
                case STARTSWITH: {
                    ft = new IgnoreDiacriticsStringFilter(this.getItemCaptionPropertyId(), filterString, true, true);
                    break;
                }
                case CONTAINS: {
                    ft = new IgnoreDiacriticsStringFilter(this.getItemCaptionPropertyId(), filterString, true, false);
                    break;
                }
            }
        }
        return ft;
    }

    @Override
    public void clearAdditionalFilter() {
        this.additionalFilter = null;
        this.filter = this.originalFilter;
        this.refresh();
    }

    public AttributeModel getAttributeModel() {
        return this.attributeModel;
    }

    public Container.Filter getFilter() {
        return this.filter;
    }

    public T getFirstItem() {
        BeanItemContainer bc = (BeanItemContainer)this.getContainerDataSource();
        return (T)((AbstractEntity)bc.firstItemId());
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public SortOrder[] getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void refresh() {
        if (SelectMode.ALL.equals((Object)this.selectMode)) {
            this.getContainerDataSource().removeAllItems();
            ((BeanItemContainer)this.getContainerDataSource()).addAll((Collection)this.service.findAll(SortUtil.translate(this.sortOrder)));
        } else if (SelectMode.FILTERED.equals((Object)this.selectMode)) {
            this.getContainerDataSource().removeAllItems();
            List list = this.service.find(new FilterConverter(null).convert(this.filter), SortUtil.translate(this.sortOrder));
            ((BeanItemContainer)this.getContainerDataSource()).addAll((Collection)list);
        }
    }

    public void refresh(Container.Filter filter) {
        this.originalFilter = filter;
        this.filter = filter;
        this.refresh();
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        this.setValue(null);
        this.additionalFilter = additionalFilter;
        this.filter = this.originalFilter == null ? additionalFilter : new And(new Container.Filter[]{this.originalFilter, additionalFilter});
        this.refresh();
    }

    public void setSelectMode(SelectMode selectMode) {
        this.selectMode = selectMode;
    }

    @Override
    public Container.Filter getAdditionalFilter() {
        return this.additionalFilter;
    }

    public void setFilter(Container.Filter filter) {
        this.filter = filter;
    }

    public static enum SelectMode {
        ALL,
        FILTERED,
        FIXED;

    }
}

