/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.filter.FilterConverter;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.Cascadable;
import com.ocs.dynamo.ui.utils.SortUtil;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.filter.And;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.ListSelect;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EntityListSelect<ID extends Serializable, T extends AbstractEntity<ID>>
extends ListSelect
implements Refreshable,
Cascadable {
    private static final long serialVersionUID = 3041574615271340579L;
    private final AttributeModel attributeModel;
    private SelectMode selectMode = SelectMode.FILTERED;
    private final SortOrder[] sortOrders;
    private BaseService<ID, T> service;
    private Container.Filter filter;
    private Container.Filter originalFilter;
    private Container.Filter additionalFilter;

    public EntityListSelect(EntityModel<T> targetEntityModel, AttributeModel attributeModel, BaseService<ID, T> service, Container.Filter filter, SortOrder ... sortOrder) {
        this(targetEntityModel, attributeModel, service, SelectMode.FILTERED, filter, null, sortOrder);
    }

    public EntityListSelect(EntityModel<T> targetEntityModel, AttributeModel attributeModel, BaseService<ID, T> service, SelectMode mode, Container.Filter filter, List<T> items, SortOrder ... sortOrders) {
        this.service = service;
        this.selectMode = mode;
        this.sortOrders = sortOrders;
        this.attributeModel = attributeModel;
        this.filter = filter;
        if (attributeModel != null) {
            this.setCaption(attributeModel.getDisplayName());
        }
        BeanItemContainer container = new BeanItemContainer(targetEntityModel.getEntityClass());
        this.setContainerDataSource((Container)container);
        if (SelectMode.ALL.equals((Object)mode)) {
            container.addAll((Collection)service.findAll(SortUtil.translate(sortOrders)));
        } else if (SelectMode.FILTERED.equals((Object)mode)) {
            items = service.find(new FilterConverter(null).convert(filter), SortUtil.translate(sortOrders));
            container.addAll((Collection)items);
        } else if (SelectMode.FIXED.equals((Object)mode)) {
            container.addAll(items);
        }
        this.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.setItemCaptionPropertyId(targetEntityModel.getDisplayProperty());
        this.setSizeFull();
    }

    public EntityListSelect(EntityModel<T> targetEntityModel, AttributeModel attributeModel, BaseService<ID, T> service, SortOrder ... sortOrder) {
        this(targetEntityModel, attributeModel, service, SelectMode.ALL, null, null, sortOrder);
    }

    public EntityListSelect(EntityModel<T> targetEntityModel, AttributeModel attributeModel, List<T> items) {
        this(targetEntityModel, attributeModel, null, SelectMode.FIXED, null, items, new SortOrder[0]);
    }

    @Override
    public void clearAdditionalFilter() {
        this.additionalFilter = this.filter;
        this.filter = this.originalFilter;
        this.refresh();
    }

    public AttributeModel getAttributeModel() {
        return this.attributeModel;
    }

    public Container.Filter getFilter() {
        return this.filter;
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public SortOrder[] getSortOrders() {
        return this.sortOrders;
    }

    @Override
    public void refresh() {
        if (SelectMode.ALL.equals((Object)this.selectMode)) {
            this.getContainerDataSource().removeAllItems();
            ((BeanItemContainer)this.getContainerDataSource()).addAll((Collection)this.service.findAll(SortUtil.translate(this.sortOrders)));
        } else if (SelectMode.FILTERED.equals((Object)this.selectMode)) {
            this.getContainerDataSource().removeAllItems();
            List list = this.service.find(new FilterConverter(null).convert(this.filter), SortUtil.translate(this.sortOrders));
            ((BeanItemContainer)this.getContainerDataSource()).addAll((Collection)list);
        }
    }

    public void refresh(Container.Filter filter) {
        this.originalFilter = filter;
        this.filter = filter;
        this.refresh();
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        this.additionalFilter = additionalFilter;
        this.filter = this.originalFilter == null ? additionalFilter : new And(new Container.Filter[]{this.originalFilter, additionalFilter});
        this.refresh();
    }

    @Override
    public Container.Filter getAdditionalFilter() {
        return this.additionalFilter;
    }

    public static enum SelectMode {
        ALL,
        FILTERED,
        FIXED;

    }
}

