/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.google.common.collect.Lists;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.QuickAddEntityField;
import com.ocs.dynamo.ui.composite.dialog.ModelBasedSearchDialog;
import com.ocs.dynamo.ui.utils.EntityModelUtil;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EntityLookupField<ID extends Serializable, T extends AbstractEntity<ID>>
extends QuickAddEntityField<ID, T, Object> {
    private static final long serialVersionUID = 5377765863515463622L;
    private boolean directNavigationAllowed;
    private boolean addAllowed;
    private Button clearButton;
    private final FetchJoinInformation[] joins;
    private Label label;
    private boolean multiSelect;
    private Integer pageLength;
    private Button selectButton;
    private List<SortOrder> sortOrders = new ArrayList<SortOrder>();

    public EntityLookupField(BaseService<ID, T> service, EntityModel<T> entityModel, AttributeModel attributeModel, Container.Filter filter, boolean search, boolean multiSelect, List<SortOrder> sortOrders, FetchJoinInformation ... joins) {
        super(service, entityModel, attributeModel, filter);
        this.sortOrders = sortOrders != null ? sortOrders : new ArrayList();
        this.joins = joins;
        this.multiSelect = multiSelect;
        this.addAllowed = !search && attributeModel != null && attributeModel.isQuickAddAllowed();
        this.directNavigationAllowed = !search && attributeModel != null && attributeModel.isDirectNavigation();
    }

    public void addSortOrder(SortOrder sortOrder) {
        this.sortOrders.add(sortOrder);
    }

    @Override
    protected void afterNewEntityAdded(T entity) {
        if (this.multiSelect) {
            if (this.getValue() == null) {
                this.setValue(Lists.newArrayList((Object[])new AbstractEntity[]{entity}));
            } else {
                Collection col = (Collection)this.getValue();
                col.add(entity);
                this.setValue(col);
            }
        } else {
            this.setValue(entity);
        }
    }

    public Button getClearButton() {
        return this.clearButton;
    }

    public Integer getPageLength() {
        return this.pageLength;
    }

    public Button getSelectButton() {
        return this.selectButton;
    }

    public List<SortOrder> getSortOrders() {
        return Collections.unmodifiableList(this.sortOrders);
    }

    public Class<?> getType() {
        return Object.class;
    }

    protected Component initContent() {
        DefaultHorizontalLayout bar = new DefaultHorizontalLayout(false, true, true);
        if (this.getAttributeModel() != null) {
            this.setCaption(this.getAttributeModel().getDisplayName());
        }
        this.label = new Label();
        this.updateLabel(this.getValue());
        bar.addComponent((Component)this.label);
        this.selectButton = new Button(this.getMessageService().getMessage("ocs.select", VaadinUtils.getLocale()));
        this.selectButton.setIcon((Resource)FontAwesome.SEARCH);
        this.selectButton.addClickListener((Button.ClickListener & Serializable)event -> {
            ArrayList<Container.Filter> filterList = new ArrayList<Container.Filter>();
            if (this.getFilter() != null) {
                filterList.add(this.getFilter());
            }
            if (this.getAdditionalFilter() != null) {
                filterList.add(this.getAdditionalFilter());
            }
            ModelBasedSearchDialog dialog = new ModelBasedSearchDialog<ID, T>(this.getService(), this.getEntityModel(), filterList, this.sortOrders, this.multiSelect, true, this.joins){
                private static final long serialVersionUID = -3432107069929941520L;

                @Override
                protected boolean doClose() {
                    if (EntityLookupField.this.multiSelect) {
                        if (EntityLookupField.this.getValue() == null) {
                            EntityLookupField.this.setValue(this.getSelectedItems());
                        } else {
                            Collection current = (Collection)EntityLookupField.this.getValue();
                            for (AbstractEntity t : this.getSelectedItems()) {
                                if (current.contains(t)) continue;
                                current.add(t);
                            }
                            EntityLookupField.this.setValue(current);
                        }
                    } else {
                        EntityLookupField.this.setValue(this.getSelectedItem());
                    }
                    return true;
                }
            };
            dialog.setPageLength(this.pageLength);
            dialog.build();
            this.getUi().addWindow((Window)dialog);
        });
        bar.addComponent((Component)this.selectButton);
        this.clearButton = new Button(this.getMessageService().getMessage("ocs.clear", VaadinUtils.getLocale()));
        this.clearButton.setIcon((Resource)FontAwesome.ERASER);
        this.clearButton.addClickListener((Button.ClickListener & Serializable)event -> this.setValue(null));
        bar.addComponent((Component)this.clearButton);
        if (this.addAllowed) {
            Button addButton = this.constructAddButton();
            bar.addComponent((Component)addButton);
        }
        if (this.directNavigationAllowed) {
            Button directNavigationButton = this.constructDirectNavigationButton();
            bar.addComponent((Component)directNavigationButton);
        }
        return bar;
    }

    public void selectValuesInDialog(ModelBasedSearchDialog<ID, T> dialog) {
        if (this.multiSelect && this.getValue() != null && this.getValue() instanceof Collection) {
            ArrayList<Object> ids = new ArrayList<Object>();
            Collection col = (Collection)this.getValue();
            for (AbstractEntity t : col) {
                ids.add(t.getId());
            }
            dialog.select(ids);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.selectButton != null) {
            this.selectButton.setEnabled(enabled);
            this.clearButton.setEnabled(enabled);
            if (this.getAddButton() != null) {
                this.getAddButton().setEnabled(enabled);
            }
        }
    }

    protected void setInternalValue(Object newValue) {
        super.setInternalValue(newValue);
        this.updateLabel(newValue);
    }

    public void setPageLength(Integer pageLength) {
        this.pageLength = pageLength;
    }

    public void setValue(Object newFieldValue) {
        super.setValue(newFieldValue);
        this.updateLabel(newFieldValue);
    }

    private void updateLabel(Object newValue) {
        if (this.label != null) {
            this.label.setCaptionAsHtml(true);
            String caption = this.getMessageService().getMessage("ocs.no.item.selected", VaadinUtils.getLocale());
            if (newValue instanceof Collection) {
                Collection col = (Collection)newValue;
                if (!col.isEmpty()) {
                    caption = EntityModelUtil.getDisplayPropertyValue(col, this.getEntityModel(), SystemPropertyUtils.getLookupFieldMaxItems(), this.getMessageService());
                }
            } else {
                AbstractEntity t = (AbstractEntity)newValue;
                if (newValue != null) {
                    caption = EntityModelUtil.getDisplayPropertyValue(t, this.getEntityModel());
                }
            }
            this.label.setCaption(caption.replaceAll(",", "<br/>"));
        }
    }

    @Override
    public void refresh(Container.Filter filter) {
        this.setFilter(filter);
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        this.setValue(null);
        super.setAdditionalFilter(additionalFilter);
    }

    public void setComponentError(ErrorMessage componentError) {
        if (this.label != null) {
            this.label.setComponentError(componentError);
        }
    }
}

