/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.component.EntityComboBox;
import com.ocs.dynamo.ui.component.QuickAddEntityField;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.filter.And;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ListSelect;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class FancyListSelect<ID extends Serializable, T extends AbstractEntity<ID>>
extends QuickAddEntityField<ID, T, Object>
implements Refreshable {
    private static final long serialVersionUID = 8129335343598146079L;
    private boolean addAllowed;
    private Button clearButton;
    private EntityComboBox<ID, T> comboBox;
    private BeanItemContainer<T> container;
    private ListSelect listSelect;
    private Button removeButton;
    private Button selectButton;
    private SortOrder[] sortOrders;

    public FancyListSelect(BaseService<ID, T> service, EntityModel<T> entityModel, AttributeModel attributeModel, Container.Filter filter, boolean search, SortOrder ... sortOrders) {
        super(service, entityModel, attributeModel, filter);
        this.sortOrders = sortOrders;
        this.addAllowed = !search && attributeModel != null && attributeModel.isQuickAddAllowed();
        this.container = new BeanItemContainer(this.getEntityModel().getEntityClass());
        this.listSelect = new ListSelect(null, this.container);
        this.comboBox = new EntityComboBox(this.getEntityModel(), this.getAttributeModel(), this.getService(), this.getFilter(), sortOrders);
    }

    @Override
    protected void afterNewEntityAdded(T entity) {
        this.comboBox.addEntity(entity);
        this.container.addBean(entity);
        this.copyValueFromContainer();
    }

    @Override
    public void clearAdditionalFilter() {
        super.clearAdditionalFilter();
        if (this.comboBox != null) {
            this.comboBox.refresh(this.getFilter());
        }
    }

    private void copyValueFromContainer() {
        List values = this.container.getItemIds();
        this.setValue(new HashSet(values));
    }

    public void focus() {
        super.focus();
        if (this.comboBox != null) {
            this.comboBox.focus();
        }
    }

    public Button getClearButton() {
        return this.clearButton;
    }

    public EntityComboBox<ID, T> getComboBox() {
        return this.comboBox;
    }

    public ListSelect getListSelect() {
        return this.listSelect;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Button getSelectButton() {
        return this.selectButton;
    }

    public SortOrder[] getSortOrders() {
        return this.sortOrders;
    }

    public Class<?> getType() {
        return Object.class;
    }

    protected Component initContent() {
        DefaultVerticalLayout layout = new DefaultVerticalLayout(false, false);
        DefaultHorizontalLayout firstBar = new DefaultHorizontalLayout(false, false, true);
        firstBar.setSizeFull();
        this.comboBox.setCaption(null);
        this.comboBox.setSizeFull();
        firstBar.addComponent((Component)this.comboBox);
        layout.addComponent((Component)firstBar);
        DefaultHorizontalLayout secondBar = new DefaultHorizontalLayout(false, true, true);
        firstBar.addComponent((Component)secondBar);
        this.selectButton = new Button(this.getMessageService().getMessage("ocs.select", VaadinUtils.getLocale()));
        this.selectButton.addClickListener((Button.ClickListener & Serializable)event -> {
            if (this.comboBox.getValue() != null && !this.container.containsId(this.comboBox.getValue())) {
                this.container.addBean((Object)((AbstractEntity)this.comboBox.getValue()));
                this.copyValueFromContainer();
            }
            this.comboBox.setValue(null);
        });
        secondBar.addComponent((Component)this.selectButton);
        this.removeButton = new Button(this.getMessageService().getMessage("ocs.remove", VaadinUtils.getLocale()));
        this.removeButton.addClickListener((Button.ClickListener & Serializable)event -> {
            Object value = this.listSelect.getValue();
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                for (AbstractEntity t : col) {
                    this.container.removeItem((Object)t);
                    this.copyValueFromContainer();
                }
            }
        });
        secondBar.addComponent((Component)this.removeButton);
        this.clearButton = new Button(this.getMessageService().getMessage("ocs.clear", VaadinUtils.getLocale()));
        this.clearButton.addClickListener((Button.ClickListener & Serializable)event -> {
            this.setValue(new HashSet());
            this.copyValueFromContainer();
        });
        secondBar.addComponent((Component)this.clearButton);
        if (this.addAllowed) {
            Button addButton = this.constructAddButton();
            secondBar.addComponent((Component)addButton);
        }
        this.listSelect.setSizeFull();
        this.listSelect.setNullSelectionAllowed(false);
        this.listSelect.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.listSelect.setItemCaptionPropertyId((Object)this.getEntityModel().getDisplayProperty());
        this.listSelect.setMultiSelect(true);
        layout.addComponent((Component)this.listSelect);
        return layout;
    }

    @Override
    public void refresh() {
        if (this.comboBox != null) {
            this.comboBox.refresh();
        }
    }

    @Override
    public void refresh(Container.Filter filter) {
        this.setFilter(filter);
        if (this.comboBox != null) {
            this.comboBox.refresh(filter);
        }
    }

    private void repopulateContainer(Object value) {
        if (this.container != null) {
            this.container.removeAllItems();
            if (value != null && value instanceof Collection) {
                this.container.addAll((Collection)value);
            }
        }
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        super.setAdditionalFilter(additionalFilter);
        if (this.comboBox != null) {
            this.comboBox.setValue(null);
            this.comboBox.refresh((Container.Filter)(this.getFilter() == null ? additionalFilter : new And(new Container.Filter[]{this.getFilter(), additionalFilter})));
        }
    }

    protected void setInternalValue(Object newValue) {
        super.setInternalValue(newValue);
        this.repopulateContainer(newValue);
    }

    public void setRows(int rows) {
        if (this.listSelect != null) {
            this.listSelect.setRows(rows);
        }
    }

    public void setValue(Object newFieldValue) {
        super.setValue(newFieldValue);
        this.repopulateContainer(newFieldValue);
    }
}

