/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.explicatis.ext_token_field.ExtTokenField;
import com.explicatis.ext_token_field.Tokenizable;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class GenericTokenFieldUtil {
    private GenericTokenFieldUtil() {
    }

    static void initializeOrdering(SortOrder[] sortOrders, List<Object> sortProperties, List<Boolean> sortOrdering) {
        if (sortOrders != null) {
            for (SortOrder sortOrder : sortOrders) {
                sortProperties.add(sortOrder.getPropertyId());
                sortOrdering.add(sortOrder.getDirection().equals((Object)SortDirection.ASCENDING));
            }
        }
    }

    private static <T> void addTokens(ExtTokenField extTokenField, BeanItemContainer<T> container, Collection<Property.ValueChangeListener> valueChangeListeners, Field<?> field, TokenizableFactory<T> tokenizableFactory) {
        extTokenField.clear();
        if (container.size() > 0) {
            for (Object item : container.getItemIds()) {
                Tokenizable token = tokenizableFactory.createToken(item);
                extTokenField.addTokenizable(token);
            }
        }
        for (Property.ValueChangeListener valueChangeListener : valueChangeListeners) {
            valueChangeListener.valueChange((Property.ValueChangeEvent)new Field.ValueChangeEvent(field));
        }
    }

    private static <T> void attachComboBoxValueChange(ComboBox comboBox, ExtTokenField extTokenField, BeanItemContainer<T> container, Collection<Property.ValueChangeListener> valueChangeListeners, Field<?> field, TokenizableFactory<T> tokenizableFactory) {
        comboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            Object selectedObject = event.getProperty().getValue();
            if (selectedObject != null) {
                Object value = selectedObject;
                GenericTokenFieldUtil.addValueToContainer(value, container);
                GenericTokenFieldUtil.addTokens(extTokenField, container, valueChangeListeners, field, tokenizableFactory);
                comboBox.setValue(null);
                comboBox.getContainerDataSource().removeItem(value);
                GenericTokenFieldUtil.copyValueFromContainer(container, field);
            }
        });
    }

    private static <T> void attachTokenFieldValueChange(ExtTokenField extTokenField, BeanItemContainer<T> container, ComboBox comboBox, List<Object> sortProperties, List<Boolean> sortOrdering, Field<?> field, TokenizableFactory<T> tokenizableFactory) {
        extTokenField.addTokenRemovedListener(event -> {
            Tokenizable tokenizable = event.getTokenizable();
            tokenizableFactory.removeTokenFromContainer(tokenizable, container);
            comboBox.setValue(null);
            tokenizableFactory.addTokenToComboBox(tokenizable, comboBox);
            GenericTokenFieldUtil.sortComboBox(comboBox, sortProperties, sortOrdering);
            GenericTokenFieldUtil.copyValueFromContainer(container, field);
        });
    }

    static void sortComboBox(ComboBox comboBox, List<Object> sortProperties, List<Boolean> sortOrdering) {
        if (sortProperties != null && sortOrdering != null) {
            Object[] sortPropertiesArray = sortProperties.toArray(new Object[sortProperties.size()]);
            boolean[] sortOrderingArray = new boolean[sortOrdering.size()];
            for (int i = 0; i < sortOrdering.size(); ++i) {
                sortOrderingArray[i] = sortOrdering.get(i);
            }
            ((Container.Sortable)comboBox.getContainerDataSource()).sort(sortPropertiesArray, sortOrderingArray);
        }
    }

    static <T> void copyValueFromContainer(BeanItemContainer<T> container, Field field) {
        List values = container.getItemIds();
        field.setValue(new HashSet(values));
    }

    static <T> void addValueToContainer(T value, BeanItemContainer<T> container) {
        container.addBean(value);
    }

    static <T> Component initContent(ComboBox comboBox, MessageService messageService, ExtTokenField extTokenField, BeanItemContainer<T> container, Collection<Property.ValueChangeListener> valueChangeListeners, Field<?> field, List<Object> sortProperties, List<Boolean> sortOrdering, PostProcessLayout processLayout, TokenizableFactory<T> tokenizableFactory) {
        DefaultHorizontalLayout layout = new DefaultHorizontalLayout(false, true, false);
        comboBox.setInputPrompt(messageService.getMessage("ocs.type.to.add", VaadinUtils.getLocale()));
        comboBox.setFilteringMode(FilteringMode.CONTAINS);
        comboBox.setNullSelectionAllowed(false);
        comboBox.setWidth(25.0f, Sizeable.Unit.PERCENTAGE);
        comboBox.setHeightUndefined();
        extTokenField.setInputField(comboBox);
        extTokenField.setEnableDefaultDeleteTokenAction(true);
        GenericTokenFieldUtil.attachComboBoxValueChange(comboBox, extTokenField, container, valueChangeListeners, field, tokenizableFactory);
        GenericTokenFieldUtil.attachTokenFieldValueChange(extTokenField, container, comboBox, sortProperties, sortOrdering, field, tokenizableFactory);
        layout.addComponent((Component)extTokenField);
        GenericTokenFieldUtil.addTokens(extTokenField, container, valueChangeListeners, field, tokenizableFactory);
        container.addItemSetChangeListener((Container.ItemSetChangeListener & Serializable)event -> GenericTokenFieldUtil.addTokens(extTokenField, container, valueChangeListeners, field, tokenizableFactory));
        processLayout.postProcessLayout((AbstractOrderedLayout)layout);
        layout.setSizeFull();
        return layout;
    }

    @FunctionalInterface
    static interface PostProcessLayout {
        public void postProcessLayout(AbstractOrderedLayout var1);
    }

    static interface TokenizableFactory<T> {
        public Tokenizable createToken(T var1);

        public void removeTokenFromContainer(Tokenizable var1, BeanItemContainer<T> var2);

        public void addTokenToComboBox(Tokenizable var1, ComboBox var2);
    }
}

