/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import java.text.Normalizer;
import org.apache.commons.lang.ObjectUtils;

public class IgnoreDiacriticsStringFilter
implements Container.Filter {
    private static final long serialVersionUID = -8965855020406086688L;
    private final Object propertyId;
    private final String filterString;
    private final boolean ignoreCase;
    private final boolean onlyMatchPrefix;

    public IgnoreDiacriticsStringFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        this.propertyId = propertyId;
        this.filterString = ignoreCase ? filterString.toLowerCase() : filterString;
        this.ignoreCase = ignoreCase;
        this.onlyMatchPrefix = onlyMatchPrefix;
    }

    public boolean passesFilter(Object itemId, Item item) {
        Property p = item.getItemProperty(this.propertyId);
        if (p == null) {
            return false;
        }
        Object propertyValue = p.getValue();
        if (propertyValue == null) {
            return false;
        }
        String temp = this.ignoreCase ? propertyValue.toString().toLowerCase() : propertyValue.toString();
        temp = Normalizer.normalize(temp, Normalizer.Form.NFD);
        String value = temp = temp.replaceAll("[^\\p{ASCII}]", "");
        return !(this.onlyMatchPrefix ? !value.startsWith(this.filterString) : !value.contains(this.filterString));
    }

    public boolean appliesToProperty(Object propertyId) {
        return this.propertyId.equals(propertyId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IgnoreDiacriticsStringFilter)) {
            return false;
        }
        IgnoreDiacriticsStringFilter o = (IgnoreDiacriticsStringFilter)obj;
        return ObjectUtils.equals((Object)this.propertyId, (Object)o.propertyId) && ObjectUtils.equals((Object)this.filterString, (Object)o.filterString) && ObjectUtils.equals((Object)this.ignoreCase, (Object)o.ignoreCase) && ObjectUtils.equals((Object)this.onlyMatchPrefix, (Object)o.onlyMatchPrefix);
    }

    public int hashCode() {
        return (this.propertyId != null ? this.propertyId.hashCode() : 0) ^ (this.filterString != null ? this.filterString.hashCode() : 0);
    }

    public Object getPropertyId() {
        return this.propertyId;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isOnlyMatchPrefix() {
        return this.onlyMatchPrefix;
    }
}

