/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.EntityComboBox;
import com.ocs.dynamo.ui.component.QuickAddEntityField;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.filter.And;
import com.vaadin.server.ErrorMessage;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.io.Serializable;
import java.util.List;

public class QuickAddEntityComboBox<ID extends Serializable, T extends AbstractEntity<ID>>
extends QuickAddEntityField<ID, T, T>
implements Refreshable {
    private static final long serialVersionUID = 4246187881499965296L;
    private final boolean quickAddAllowed;
    private final boolean directNavigationAllowed;
    private static final float BUTTON_EXPAND_RATIO = 0.25f;
    private EntityComboBox<ID, T> comboBox;

    public QuickAddEntityComboBox(EntityModel<T> entityModel, AttributeModel attributeModel, BaseService<ID, T> service, EntityComboBox.SelectMode mode, Container.Filter filter, boolean search, List<T> items, SortOrder ... sortOrder) {
        super(service, entityModel, attributeModel, filter);
        this.comboBox = new EntityComboBox<ID, T>(entityModel, attributeModel, service, mode, filter, items, sortOrder);
        this.quickAddAllowed = attributeModel != null && attributeModel.isQuickAddAllowed() && !search;
        this.directNavigationAllowed = attributeModel != null && attributeModel.isDirectNavigation() && !search;
    }

    @Override
    protected void afterNewEntityAdded(T entity) {
        BeanItemContainer container = (BeanItemContainer)this.comboBox.getContainerDataSource();
        container.addBean(entity);
        this.comboBox.setValue(entity);
    }

    @Override
    public void clearAdditionalFilter() {
        super.clearAdditionalFilter();
        if (this.comboBox != null) {
            this.comboBox.refresh(this.getFilter());
        }
    }

    public EntityComboBox<ID, T> getComboBox() {
        return this.comboBox;
    }

    public Class<? extends T> getType() {
        return this.getEntityModel().getEntityClass();
    }

    protected Component initContent() {
        DefaultHorizontalLayout bar = new DefaultHorizontalLayout(false, true, true);
        bar.setSizeFull();
        if (this.getAttributeModel() != null) {
            this.setCaption(this.getAttributeModel().getDisplayName());
        }
        this.comboBox.setCaption(null);
        this.comboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.setValue((T)((AbstractEntity)event.getProperty().getValue())));
        this.comboBox.setSizeFull();
        bar.addComponent((Component)this.comboBox);
        float comboBoxExpandRatio = 1.0f;
        if (this.quickAddAllowed) {
            comboBoxExpandRatio -= 0.25f;
        }
        if (this.directNavigationAllowed) {
            comboBoxExpandRatio -= 0.1f;
        }
        bar.setExpandRatio((Component)this.comboBox, comboBoxExpandRatio);
        if (this.quickAddAllowed) {
            Button addButton = this.constructAddButton();
            addButton.setSizeFull();
            bar.addComponent((Component)addButton);
            bar.setExpandRatio((Component)addButton, 0.25f);
        }
        if (this.directNavigationAllowed) {
            Button directNavigationButton = this.constructDirectNavigationButton();
            bar.addComponent((Component)directNavigationButton);
            bar.setExpandRatio((Component)directNavigationButton, 0.1f);
        }
        return bar;
    }

    @Override
    public void refresh() {
        if (this.comboBox != null) {
            this.comboBox.refresh();
        }
    }

    @Override
    public void refresh(Container.Filter filter) {
        this.setFilter(filter);
        if (this.comboBox != null) {
            this.comboBox.refresh(filter);
        }
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        super.setAdditionalFilter(additionalFilter);
        if (this.comboBox != null) {
            this.comboBox.refresh((Container.Filter)(this.getFilter() == null ? additionalFilter : new And(new Container.Filter[]{this.getFilter(), additionalFilter})));
        }
    }

    protected void setInternalValue(T newValue) {
        super.setInternalValue(newValue);
        if (this.comboBox != null) {
            this.comboBox.setValue(newValue);
        }
    }

    public void setValue(T newFieldValue) {
        super.setValue(newFieldValue);
        if (this.comboBox != null) {
            this.comboBox.setValue(newFieldValue);
        }
    }

    public void setComponentError(ErrorMessage componentError) {
        if (this.comboBox != null) {
            this.comboBox.setComponentError(componentError);
        }
    }
}

