/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.BaseUI;
import com.ocs.dynamo.ui.component.AddNewValueDialog;
import com.ocs.dynamo.ui.component.CustomEntityField;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;

public abstract class QuickAddEntityField<ID extends Serializable, T extends AbstractEntity<ID>, U>
extends CustomEntityField<ID, T, U> {
    private static final long serialVersionUID = 7118578276952170818L;
    private UI ui = UI.getCurrent();
    private Button addButton;
    private Button directNavigationButton;
    private Container.Filter additionalFilter;

    public QuickAddEntityField(BaseService<ID, T> service, EntityModel<T> entityModel, AttributeModel attributeModel, Container.Filter filter) {
        super(service, entityModel, attributeModel, filter);
    }

    protected abstract void afterNewEntityAdded(T var1);

    protected Button constructAddButton() {
        this.addButton = new Button(this.getMessageService().getMessage("ocs.add", VaadinUtils.getLocale()));
        this.addButton.setIcon((Resource)FontAwesome.PLUS);
        this.addButton.addClickListener((Button.ClickListener & Serializable)event -> {
            AddNewValueDialog dialog = new AddNewValueDialog<ID, T>(this.getEntityModel(), this.getAttributeModel(), this.getService(), this.getMessageService()){
                private static final long serialVersionUID = 2040216794358094524L;

                @Override
                protected void afterNewEntityAdded(T entity) {
                    QuickAddEntityField.this.afterNewEntityAdded(entity);
                }
            };
            dialog.build();
            this.ui.addWindow((Window)dialog);
        });
        return this.addButton;
    }

    protected Button constructDirectNavigationButton() {
        this.directNavigationButton = new Button(this.getMessageService().getMessage("ocs.direct.navigate", VaadinUtils.getLocale()));
        this.directNavigationButton.addClickListener((Button.ClickListener & Serializable)event -> ((BaseUI)this.ui).navigateToEntityScreenDirectly(this.getValue()));
        return this.directNavigationButton;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getDirectNavigationButton() {
        return this.directNavigationButton;
    }

    @Override
    public Container.Filter getAdditionalFilter() {
        return this.additionalFilter;
    }

    public UI getUi() {
        return this.ui;
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        this.additionalFilter = additionalFilter;
    }

    @Override
    public void clearAdditionalFilter() {
        this.additionalFilter = null;
    }
}

