/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.EntityListSelect;
import com.ocs.dynamo.ui.component.QuickAddEntityField;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.filter.And;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.io.Serializable;

public class QuickAddListSelect<ID extends Serializable, T extends AbstractEntity<ID>>
extends QuickAddEntityField<ID, T, Object>
implements Refreshable {
    private static final long serialVersionUID = 4246187881499965296L;
    private EntityListSelect<ID, T> listSelect;
    private boolean viewMode;
    private boolean quickAddAllowed;
    private boolean directNavigationAllowed;

    public QuickAddListSelect(EntityModel<T> entityModel, AttributeModel attributeModel, BaseService<ID, T> service, Container.Filter filter, boolean multiSelect, int rows, SortOrder ... sortOrder) {
        super(service, entityModel, attributeModel, filter);
        this.listSelect = new EntityListSelect<ID, T>(entityModel, attributeModel, service, filter, sortOrder);
        this.listSelect.setMultiSelect(multiSelect);
        this.listSelect.setRows(rows);
        this.quickAddAllowed = attributeModel != null && attributeModel.isQuickAddAllowed();
        this.directNavigationAllowed = attributeModel != null && attributeModel.isDirectNavigation();
    }

    @Override
    protected void afterNewEntityAdded(T entity) {
        BeanItemContainer container = (BeanItemContainer)this.listSelect.getContainerDataSource();
        container.addBean(entity);
        this.listSelect.select(entity);
    }

    @Override
    public void clearAdditionalFilter() {
        super.clearAdditionalFilter();
        if (this.listSelect != null) {
            this.listSelect.refresh(this.getFilter());
        }
    }

    public EntityListSelect<ID, T> getListSelect() {
        return this.listSelect;
    }

    public Class<?> getType() {
        return Object.class;
    }

    protected Component initContent() {
        DefaultHorizontalLayout bar = new DefaultHorizontalLayout(false, true, true);
        bar.setSizeFull();
        if (this.getAttributeModel() != null) {
            this.setCaption(this.getAttributeModel().getDisplayName());
        }
        this.listSelect.setCaption(null);
        this.listSelect.setSizeFull();
        this.listSelect.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.setValue(event.getProperty().getValue()));
        bar.addComponent((Component)this.listSelect);
        float listExpandRatio = 1.0f;
        if (this.quickAddAllowed && !this.viewMode) {
            listExpandRatio -= 0.1f;
        }
        if (this.directNavigationAllowed) {
            listExpandRatio -= 0.05f;
        }
        bar.setExpandRatio((Component)this.listSelect, listExpandRatio);
        if (!this.viewMode && this.quickAddAllowed) {
            Button addButton = this.constructAddButton();
            bar.addComponent((Component)addButton);
            bar.setExpandRatio((Component)addButton, 0.1f);
        }
        if (this.directNavigationAllowed) {
            Button directNavigationButton = this.constructDirectNavigationButton();
            bar.addComponent((Component)directNavigationButton);
            bar.setExpandRatio((Component)directNavigationButton, 0.05f);
        }
        return bar;
    }

    @Override
    public void refresh() {
        if (this.listSelect != null) {
            this.listSelect.refresh();
        }
    }

    @Override
    public void refresh(Container.Filter filter) {
        this.setFilter(filter);
        if (this.listSelect != null) {
            this.listSelect.refresh(filter);
        }
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        super.setAdditionalFilter(additionalFilter);
        if (this.listSelect != null) {
            this.listSelect.refresh((Container.Filter)(this.getFilter() == null ? additionalFilter : new And(new Container.Filter[]{this.getFilter(), additionalFilter})));
        }
    }

    protected void setInternalValue(Object newValue) {
        super.setInternalValue(newValue);
        if (this.listSelect != null) {
            this.listSelect.setValue(newValue);
        }
    }

    public void setValue(Object newFieldValue) {
        super.setValue(newFieldValue);
        if (this.listSelect != null) {
            this.listSelect.setValue(newFieldValue);
        }
    }

    public void setViewMode(boolean viewMode) {
        this.viewMode = viewMode;
    }
}

