/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.explicatis.ext_token_field.ExtTokenField;
import com.explicatis.ext_token_field.SimpleTokenizable;
import com.explicatis.ext_token_field.Tokenizable;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.filter.FilterConverter;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.GenericTokenFieldUtil;
import com.ocs.dynamo.ui.utils.SortUtil;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.data.util.ItemSorter;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleTokenFieldSelect<ID extends Serializable, S extends AbstractEntity<ID>, T extends Comparable<T>>
extends CustomField<Collection<T>>
implements Refreshable {
    private static final long serialVersionUID = -1490179285573442827L;
    private AttributeModel attributeModel;
    private final ExtTokenField extTokenField;
    private final boolean elementCollection;
    private final ComboBox comboBox;
    private final BeanItemContainer<T> container;
    private final Collection<Property.ValueChangeListener> valueChangeListeners;
    private List<Object> sortProperties;
    private List<Boolean> sortOrdering;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
    private GenericTokenFieldUtil.TokenizableFactory<T> tokenizableFactory;
    private BaseService<ID, S> service;
    private EntityModel<S> entityModel;
    private Container.Filter fieldFilter;
    private String distinctField;
    private SortOrder[] sortOrders;
    private Class<T> elementType;

    public SimpleTokenFieldSelect(BaseService<ID, S> service, EntityModel<S> entityModel, AttributeModel attributeModel, Container.Filter fieldFilter, String distinctField, Class<T> elementType, boolean elementCollection, SortOrder ... sortOrders) {
        this.service = service;
        this.entityModel = entityModel;
        this.fieldFilter = fieldFilter;
        this.distinctField = distinctField;
        this.sortOrders = sortOrders;
        this.elementType = elementType;
        this.elementCollection = elementCollection;
        this.attributeModel = attributeModel;
        this.setCaption(attributeModel.getDisplayName());
        this.extTokenField = new ExtTokenField();
        this.comboBox = new ComboBox();
        this.comboBox.setFilteringMode(FilteringMode.CONTAINS);
        this.fillComboBox(this.elementCollection);
        this.sortProperties = new ArrayList<Object>();
        this.sortOrdering = new ArrayList<Boolean>();
        GenericTokenFieldUtil.initializeOrdering(sortOrders, this.sortProperties, this.sortOrdering);
        ((IndexedContainer)this.comboBox.getContainerDataSource()).setItemSorter((ItemSorter)new SimpleItemSorter());
        this.container = new BeanItemContainer(elementType);
        this.valueChangeListeners = new ArrayList<Property.ValueChangeListener>();
        this.tokenizableFactory = new GenericTokenFieldUtil.TokenizableFactory<T>(){

            @Override
            public void addTokenToComboBox(Tokenizable tokenizable, ComboBox comboBox) {
                comboBox.addItem((Object)tokenizable.getStringValue());
            }

            @Override
            public Tokenizable createToken(T item) {
                return new SimpleTokenizable(System.nanoTime(), item.toString());
            }

            @Override
            public void removeTokenFromContainer(Tokenizable tokenizable, BeanItemContainer<T> container) {
                container.removeItem((Object)tokenizable.getStringValue());
            }
        };
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.valueChangeListeners.add(listener);
    }

    private void fillComboBox(boolean elementCollection) {
        List items = null;
        items = elementCollection ? this.service.findDistinctInCollectionTable(this.attributeModel.getCollectionTableName(), this.attributeModel.getCollectionTableFieldName(), this.elementType) : this.service.findDistinct(new FilterConverter(this.entityModel).convert(this.fieldFilter), this.distinctField, this.elementType, SortUtil.translate(this.sortOrders));
        this.comboBox.removeAllItems();
        this.comboBox.addItems((Collection)items);
    }

    public ComboBox getComboBox() {
        return this.comboBox;
    }

    protected List<T> getInternalValue() {
        if (this.container.size() == 0) {
            return null;
        }
        return this.container.getItemIds();
    }

    public ExtTokenField getTokenField() {
        return this.extTokenField;
    }

    public Class<Collection<T>> getType() {
        return Collection.class;
    }

    public List<T> getValue() {
        return this.getInternalValue();
    }

    protected Component initContent() {
        return GenericTokenFieldUtil.initContent(this.comboBox, this.messageService, this.extTokenField, this.container, this.valueChangeListeners, this, this.sortProperties, this.sortOrdering, layout -> {}, this.tokenizableFactory);
    }

    @Override
    public void refresh() {
        if (this.comboBox != null) {
            this.fillComboBox(this.elementCollection);
        }
    }

    protected void setInternalValue(Collection<T> values) {
        super.setInternalValue(values);
        if (values == null && !this.container.getItemIds().isEmpty()) {
            for (Comparable item : this.container.getItemIds()) {
                this.comboBox.getContainerDataSource().addItem((Object)item);
            }
            GenericTokenFieldUtil.sortComboBox(this.comboBox, this.sortProperties, this.sortOrdering);
        }
        this.container.removeAllItems();
        if (values != null) {
            this.container.addAll(values);
        }
    }

    public void setValue(Collection<T> values) {
        super.setValue(values);
        this.setInternalValue(values);
    }

    private class SimpleItemSorter
    implements ItemSorter {
        private static final long serialVersionUID = -2397932123434432733L;
        private boolean sortOrderAscending;

        private SimpleItemSorter() {
        }

        public int compare(Object itemId1, Object itemId2) {
            Comparable item1 = (Comparable)itemId1;
            Comparable item2 = (Comparable)itemId2;
            if (item1 == null) {
                if (item2 == null) {
                    return 0;
                }
                return 1;
            }
            if (item2 == null) {
                return -1;
            }
            return this.sortOrderAscending ? item1.compareTo(item2) : item2.compareTo(item1);
        }

        public void setSortProperties(Container.Sortable container, Object[] propertyId, boolean[] ascending) {
            this.sortOrderAscending = true;
            if (ascending != null) {
                this.sortOrderAscending = ascending[0];
            }
        }
    }
}

