/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.vaadin.data.Property;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.NativeSelect;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeField
extends CustomField<Date> {
    private static final long serialVersionUID = -676425827861766118L;
    private boolean use24HourClock = true;
    private Locale givenLocale = null;
    private final NativeSelect hourSelect;
    private final NativeSelect minuteSelect;
    private final NativeSelect secondSelect;
    private Resolution resolution = Resolution.MINUTE;
    private int intervalMinutes = 1;
    private int minHours = 0;
    private int maxHours = 23;
    private boolean maskInternalValueChange = false;
    private HorizontalLayout root;

    public TimeField(String caption) {
        this();
        this.setCaption(caption);
    }

    public TimeField() {
        this.hourSelect = this.getSelect();
        this.minuteSelect = this.getSelect();
        this.secondSelect = this.getSelect();
        this.root = new HorizontalLayout();
        this.root.setHeight(null);
        this.root.setWidth(null);
        this.fillHours();
        this.root.addComponent((Component)this.hourSelect);
        this.fillMinutes();
        this.root.addComponent((Component)this.minuteSelect);
        this.fillSeconds();
        this.root.addComponent((Component)this.secondSelect);
        this.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            if (this.maskInternalValueChange) {
                return;
            }
            this.updateFields();
        });
        this.addStyleName("timefield");
        this.setSizeUndefined();
        this.updateFields();
    }

    public int getHours() {
        Date d = (Date)this.getValue();
        return d.getHours();
    }

    public void setHours(int hours) {
        if (hours < this.minHours || hours > this.maxHours) {
            throw new IllegalArgumentException("Value '" + hours + "' is outside bounds '" + this.minHours + "' - '" + this.maxHours + "'");
        }
        this.hourSelect.setValue((Object)hours);
    }

    public int getMinutes() {
        Date d = (Date)this.getValue();
        return d.getMinutes();
    }

    public void setMinutes(int minutes) {
        if (minutes % this.intervalMinutes != 0) {
            throw new IllegalArgumentException("Value '" + minutes + "' is not compatible with interval '" + this.intervalMinutes + "'");
        }
        this.minuteSelect.setValue((Object)minutes);
    }

    public int getSeconds() {
        Date d = (Date)this.getValue();
        return d.getSeconds();
    }

    public void setSeconds(int seconds) {
        this.secondSelect.setValue((Object)seconds);
    }

    private void fillHours() {
        this.hourSelect.removeAllItems();
        for (int i = this.minHours; i <= this.maxHours; ++i) {
            this.hourSelect.addItem((Object)i);
            if (this.use24HourClock) continue;
            Integer val = i == 0 || i == 12 ? 12 : i % 12;
            String suffix = i < 12 ? " am" : " pm";
            this.hourSelect.setItemCaption((Object)i, val + suffix);
        }
    }

    private void fillMinutes() {
        this.minuteSelect.removeAllItems();
        for (int i = 0; i < 60; ++i) {
            if (i % this.intervalMinutes != 0) continue;
            this.minuteSelect.addItem((Object)i);
            this.minuteSelect.setItemCaption((Object)i, i < 10 ? "0" + i : Integer.toString(i));
        }
    }

    private void fillSeconds() {
        this.secondSelect.removeAllItems();
        for (int i = 0; i < 60; ++i) {
            this.secondSelect.addItem((Object)i);
            this.secondSelect.setItemCaption((Object)i, i < 10 ? "0" + i : Integer.toString(i));
        }
    }

    private NativeSelect getSelect() {
        NativeSelect select = new NativeSelect();
        select.setImmediate(true);
        select.setNullSelectionAllowed(false);
        select.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            if (this.maskInternalValueChange) {
                return;
            }
            this.maskInternalValueChange = true;
            this.updateValue();
            this.fireValueChange(true);
            this.maskInternalValueChange = false;
        });
        return select;
    }

    private void updateValue() {
        int val;
        if (this.secondSelect.getValue() == null) {
            this.secondSelect.setValue((Object)0);
        }
        if (this.minuteSelect.getValue() == null) {
            this.minuteSelect.setValue((Object)0);
        }
        if (this.hourSelect.getValue() == null) {
            this.hourSelect.setValue((Object)0);
        }
        Date newDate = new Date(0L);
        newDate.setSeconds(0);
        newDate.setMinutes(0);
        newDate.setHours(0);
        if (this.resolution.ordinal() <= Resolution.HOUR.ordinal()) {
            val = (Integer)this.hourSelect.getValue();
            newDate.setHours(val);
        }
        if (this.resolution.ordinal() < Resolution.HOUR.ordinal()) {
            val = (Integer)this.minuteSelect.getValue();
            newDate.setMinutes(val);
        }
        if (this.resolution.ordinal() < Resolution.MINUTE.ordinal()) {
            val = (Integer)this.secondSelect.getValue();
            newDate.setSeconds(val);
        }
        this.setValue(newDate);
    }

    private void updateFields() {
        int compatibleVal;
        this.maskInternalValueChange = true;
        this.minuteSelect.setVisible(this.resolution.ordinal() < Resolution.HOUR.ordinal());
        this.secondSelect.setVisible(this.resolution.ordinal() < Resolution.MINUTE.ordinal());
        Date val = (Date)this.getValue();
        this.fillHours();
        this.fillMinutes();
        if (val == null) {
            this.hourSelect.setValue(null);
            this.minuteSelect.setValue(null);
            this.secondSelect.setValue(null);
            this.maskInternalValueChange = false;
            return;
        }
        if (val.getHours() < this.minHours) {
            for (compatibleVal = val.getHours(); compatibleVal < 24 && compatibleVal < this.minHours; ++compatibleVal) {
            }
            if (compatibleVal >= this.minHours) {
                val.setHours(compatibleVal);
            }
        } else if (val.getHours() > this.maxHours) {
            for (compatibleVal = val.getHours(); compatibleVal > 0 && compatibleVal > this.maxHours; --compatibleVal) {
            }
            if (compatibleVal <= this.maxHours) {
                val.setHours(compatibleVal);
            }
        }
        this.hourSelect.setValue((Object)val.getHours());
        if (val.getMinutes() % this.intervalMinutes != 0) {
            for (compatibleVal = val.getMinutes(); compatibleVal > 0 && compatibleVal % this.intervalMinutes != 0; --compatibleVal) {
            }
            val.setMinutes(compatibleVal);
        }
        this.minuteSelect.setValue((Object)val.getMinutes());
        this.secondSelect.setValue((Object)val.getSeconds());
        this.maskInternalValueChange = false;
    }

    public void setLocale(Locale l) {
        this.givenLocale = l;
        DateFormat df = DateFormat.getTimeInstance(3, this.givenLocale);
        String time = df.format(new Date());
        this.use24HourClock = !time.contains("am") && !time.contains("AM") && !time.contains("pm") && !time.contains("PM");
        this.updateFields();
    }

    public void setResolution(Resolution resolution) {
        if (this.resolution.ordinal() < resolution.ordinal()) {
            if (resolution.ordinal() > Resolution.SECOND.ordinal()) {
                this.secondSelect.setValue((Object)0);
            }
            if (resolution.ordinal() > Resolution.MINUTE.ordinal()) {
                this.minuteSelect.setValue((Object)0);
            }
        }
        this.resolution = resolution;
        this.updateFields();
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void attach() {
        super.attach();
        if (this.givenLocale == null) {
            Locale locale;
            this.givenLocale = locale = this.getUI().getSession().getBrowser().getLocale();
        }
    }

    public void set24HourClock(boolean use24hourclock) {
        this.use24HourClock = use24hourclock;
        this.updateFields();
    }

    public boolean is24HourClock() {
        return this.use24HourClock;
    }

    public Class<? extends Date> getType() {
        return Date.class;
    }

    protected Component initContent() {
        return this.root;
    }

    public void setTabIndex(int tabIndex) {
        this.hourSelect.setTabIndex(tabIndex);
        this.minuteSelect.setTabIndex(tabIndex);
        this.secondSelect.setTabIndex(tabIndex);
    }

    public int getTabIndex() {
        return this.hourSelect.getTabIndex();
    }

    public void setReadOnly(boolean readOnly) {
        this.hourSelect.setReadOnly(readOnly);
        this.minuteSelect.setReadOnly(readOnly);
        this.secondSelect.setReadOnly(readOnly);
        super.setReadOnly(readOnly);
    }

    public int getMinuteInterval() {
        return this.intervalMinutes;
    }

    public void setMinuteInterval(int interval) {
        if (interval < 0) {
            interval = 0;
        }
        this.intervalMinutes = interval;
        this.updateFields();
    }

    public int getHourMin() {
        return this.minHours;
    }

    public void setHourMin(int minHours) {
        if (minHours < 0) {
            minHours = 0;
        }
        if (minHours > 23) {
            minHours = 23;
        }
        this.minHours = minHours;
        this.updateFields();
    }

    public int getHourMax() {
        return this.maxHours;
    }

    public void setHourMax(int maxHours) {
        if (maxHours < 0) {
            maxHours = 0;
        }
        if (maxHours > 23) {
            maxHours = 23;
        }
        this.maxHours = maxHours;
        this.updateFields();
    }
}

