/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.explicatis.ext_token_field.ExtTokenField;
import com.explicatis.ext_token_field.Tokenizable;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.EntityComboBox;
import com.ocs.dynamo.ui.component.QuickAddEntityField;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.utils.ClassUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.filter.And;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class TokenFieldSelect<ID extends Serializable, T extends AbstractEntity<ID>>
extends QuickAddEntityField<ID, T, Collection<T>>
implements Refreshable {
    private static final long serialVersionUID = -1490179285573442827L;
    private final ExtTokenField extTokenField = new ExtTokenField();
    private final EntityComboBox<ID, T> comboBox;
    private final BeanItemContainer<T> container;
    private final Collection<Property.ValueChangeListener> valueChangeListeners;
    private boolean addAllowed = false;

    public TokenFieldSelect(EntityModel<T> em, AttributeModel attributeModel, BaseService<ID, T> service, Container.Filter filter, boolean search, SortOrder ... sortOrders) {
        super(service, em, attributeModel, filter);
        this.comboBox = new EntityComboBox<ID, T>(em, attributeModel, service, filter, sortOrders);
        this.container = new BeanItemContainer(AbstractEntity.class);
        this.valueChangeListeners = new ArrayList<Property.ValueChangeListener>();
        this.addAllowed = !search && attributeModel != null && attributeModel.isQuickAddAllowed();
    }

    private void addTokens() {
        this.extTokenField.clear();
        if (this.container.size() > 0) {
            for (AbstractEntity item : this.container.getItemIds()) {
                BeanItemTokenizable token = new BeanItemTokenizable(this, item, (String)this.comboBox.getItemCaptionPropertyId());
                this.extTokenField.addTokenizable((Tokenizable)token);
            }
        }
        for (Property.ValueChangeListener valueChangeListener : this.valueChangeListeners) {
            valueChangeListener.valueChange((Property.ValueChangeEvent)new Field.ValueChangeEvent((Field)this));
        }
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.valueChangeListeners.add(listener);
    }

    @Override
    protected void afterNewEntityAdded(T entity) {
        this.comboBox.addEntity(entity);
        this.container.addBean(entity);
        this.copyValueFromContainer();
    }

    private void attachComboBoxValueChange() {
        this.comboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            Object selectedObject = event.getProperty().getValue();
            if (selectedObject != null) {
                AbstractEntity abstractEntity = (AbstractEntity)selectedObject;
                this.container.addBean((Object)abstractEntity);
                this.comboBox.setValue(null);
                this.copyValueFromContainer();
            }
        });
    }

    private void attachTokenFieldValueChange() {
        this.extTokenField.addTokenRemovedListener(event -> {
            BeanItemTokenizable tokenizable = (BeanItemTokenizable)event.getTokenizable();
            this.container.removeItem(tokenizable.getItem());
            this.copyValueFromContainer();
        });
    }

    @Override
    public void clearAdditionalFilter() {
        super.clearAdditionalFilter();
        if (this.comboBox != null) {
            this.comboBox.refresh(this.getFilter());
            this.extTokenField.setInputField(this.comboBox);
        }
    }

    private void copyValueFromContainer() {
        List values = this.container.getItemIds();
        this.setValue(new HashSet(values));
        this.setComboBoxWidth();
        this.validate();
    }

    public void focus() {
        super.focus();
        if (this.comboBox != null) {
            this.comboBox.focus();
        }
    }

    public EntityComboBox<ID, T> getComboBox() {
        return this.comboBox;
    }

    protected List<T> getInternalValue() {
        if (this.container.size() == 0) {
            return new ArrayList();
        }
        return this.container.getItemIds();
    }

    public ExtTokenField getTokenField() {
        return this.extTokenField;
    }

    public Class<Collection<T>> getType() {
        return Collection.class;
    }

    public List<T> getValue() {
        return this.getInternalValue();
    }

    protected Component initContent() {
        DefaultHorizontalLayout layout = new DefaultHorizontalLayout(false, true, false);
        this.comboBox.setInputPrompt(this.getMessageService().getMessage("ocs.type.to.add", VaadinUtils.getLocale()));
        this.comboBox.setFilteringMode(FilteringMode.CONTAINS);
        this.comboBox.setHeightUndefined();
        this.setComboBoxWidth();
        this.extTokenField.setInputField(this.comboBox);
        this.extTokenField.setEnableDefaultDeleteTokenAction(true);
        this.attachComboBoxValueChange();
        this.attachTokenFieldValueChange();
        this.setupContainerFieldSync();
        layout.addComponent((Component)this.extTokenField);
        if (this.addAllowed) {
            Button addButton = this.constructAddButton();
            layout.addComponent((Component)addButton);
            layout.setExpandRatio((Component)this.extTokenField, 0.9f);
            layout.setExpandRatio((Component)addButton, 0.1f);
        }
        this.addTokens();
        layout.setSizeFull();
        return layout;
    }

    @Override
    public void refresh() {
        if (this.comboBox != null) {
            this.comboBox.refresh();
        }
    }

    @Override
    public void refresh(Container.Filter filter) {
        if (this.comboBox != null) {
            this.comboBox.refresh(filter);
        }
    }

    @Override
    public void setAdditionalFilter(Container.Filter additionalFilter) {
        super.setAdditionalFilter(additionalFilter);
        if (this.comboBox != null) {
            this.setValue(null);
            this.comboBox.setValue(null);
            this.comboBox.refresh((Container.Filter)(this.getFilter() == null ? additionalFilter : new And(new Container.Filter[]{this.getFilter(), additionalFilter})));
            this.extTokenField.setInputField(this.comboBox);
        }
    }

    private void setComboBoxWidth() {
        if (this.container.size() > 0) {
            this.comboBox.setWidth(25.0f, Sizeable.Unit.PERCENTAGE);
        } else {
            this.comboBox.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        }
    }

    protected void setInternalValue(Collection<T> values) {
        super.setInternalValue(values);
        this.container.removeAllItems();
        if (values != null) {
            this.container.addAll(values);
        }
    }

    private void setupContainerFieldSync() {
        this.container.addItemSetChangeListener((Container.ItemSetChangeListener & Serializable)e -> this.addTokens());
    }

    public void setValue(Collection<T> values) {
        super.setValue(values);
        this.setInternalValue(values);
    }

    public void validate() throws Validator.InvalidValueException {
        if (this.getAttributeModel() != null && this.getAttributeModel().isRequired() && this.container.getItemIds().isEmpty()) {
            throw new Validator.EmptyValueException(this.getRequiredError());
        }
        super.validate();
    }

    public void setComponentError(ErrorMessage componentError) {
        if (this.comboBox != null) {
            this.comboBox.setComponentError(componentError);
        }
    }

    private static final class BeanItemTokenizable
    implements Tokenizable {
        private final T item;
        private final String displayValue;
        private final Long id;
        final /* synthetic */ TokenFieldSelect this$0;

        private BeanItemTokenizable(T item, String captionPropertyId) {
            this.this$0 = var1_1;
            this.item = item;
            this.id = this.getTokenIdentifier(item);
            this.displayValue = this.getTokenDisplayName(item, captionPropertyId);
        }

        public long getIdentifier() {
            return this.id;
        }

        public T getItem() {
            return this.item;
        }

        public String getStringValue() {
            return this.displayValue;
        }

        private String getTokenDisplayName(T entity, String captionPropertyId) {
            return ClassUtils.getFieldValueAsString(entity, (String)captionPropertyId);
        }

        private long getTokenIdentifier(T entity) {
            return Long.parseLong(ClassUtils.getFieldValueAsString(entity, (String)"id"));
        }
    }
}

