/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.component;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.vaadin.data.Property;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.BorderStyle;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Link;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class URLField
extends CustomField<String> {
    private static final long serialVersionUID = -1899451186343723434L;
    private AttributeModel attributeModel;
    private HorizontalLayout bar;
    private boolean editable;
    private Link link;
    private VerticalLayout main;
    private TextField textField;

    public URLField(TextField textField, AttributeModel attributeModel, boolean editable) {
        this.attributeModel = attributeModel;
        this.textField = textField;
        this.editable = editable;
        textField.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.setValue((String)event.getProperty().getValue()));
    }

    protected Link getLink() {
        return this.link;
    }

    public TextField getTextField() {
        return this.textField;
    }

    public Class<? extends String> getType() {
        return String.class;
    }

    protected Component initContent() {
        this.main = new VerticalLayout();
        this.setCaption(this.attributeModel.getDisplayName());
        this.bar = new DefaultHorizontalLayout(false, true, true);
        this.updateLink((String)this.getValue());
        this.setMode();
        return this.main;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.setMode();
    }

    protected void setInternalValue(String newValue) {
        super.setInternalValue((Object)newValue);
        this.updateLink(newValue);
        this.textField.setValue(newValue);
    }

    private void setMode() {
        if (this.main != null) {
            if (this.editable) {
                this.main.replaceComponent((Component)this.bar, (Component)this.textField);
            } else {
                this.main.replaceComponent((Component)this.textField, (Component)this.bar);
            }
        }
    }

    public void setValue(String newValue) {
        super.setValue((Object)newValue);
        this.updateLink(newValue);
        this.textField.setValue(newValue);
    }

    private void updateLink(String value) {
        if (this.bar != null) {
            this.bar.removeAllComponents();
            if (!StringUtils.isEmpty((String)value)) {
                String temp = com.ocs.dynamo.utils.StringUtils.prependProtocol((String)value);
                this.link = new Link(temp, (Resource)new ExternalResource(temp), "_blank", 0, 0, BorderStyle.DEFAULT);
                this.bar.addComponent((Component)this.link);
            } else {
                this.link = null;
            }
        }
    }
}

